/*
 * Decompiled with CFR 0.152.
 */
package io.appform.hope.core.functions.impl.path;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import com.jayway.jsonpath.Predicate;
import io.appform.hope.core.Value;
import io.appform.hope.core.functions.FunctionImplementation;
import io.appform.hope.core.functions.HopeFunction;
import io.appform.hope.core.utils.Converters;
import io.appform.hope.core.values.BooleanValue;
import io.appform.hope.core.visitors.Evaluator;

@FunctionImplementation(value="path.exists")
public class Exists
extends HopeFunction<BooleanValue> {
    private final Value path;

    public Exists(Value path) {
        this.path = path;
    }

    @Override
    public BooleanValue apply(Evaluator.EvaluationContext evaluationContext) {
        String pathValue = Converters.jsonPathValue(evaluationContext, this.path, "");
        if (Strings.isNullOrEmpty((String)pathValue)) {
            return new BooleanValue(false);
        }
        JsonNode node = (JsonNode)evaluationContext.getJsonContext().read(pathValue, new Predicate[0]);
        if (null == node || node.isNull() || node.isMissingNode()) {
            return new BooleanValue(false);
        }
        return new BooleanValue(true);
    }
}

