/*
 * Decompiled with CFR 0.152.
 */
package io.appform.hope.core.functions.impl.arr;

import com.google.common.collect.Sets;
import io.appform.hope.core.Value;
import io.appform.hope.core.functions.FunctionImplementation;
import io.appform.hope.core.functions.HopeFunction;
import io.appform.hope.core.utils.Converters;
import io.appform.hope.core.values.BooleanValue;
import io.appform.hope.core.visitors.Evaluator;
import java.util.Collections;
import java.util.HashSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionImplementation(value="arr.contains_any")
public class ContainsAny
extends HopeFunction<BooleanValue> {
    private static final Logger log = LoggerFactory.getLogger(ContainsAny.class);
    private final Value lhs;
    private final Value rhs;

    public ContainsAny(Value lhs, Value rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public BooleanValue apply(Evaluator.EvaluationContext evaluationContext) {
        TreeSet<Object> lhsValues = new TreeSet<Object>(Converters.flattenArray(evaluationContext, this.lhs, Collections.emptyList()));
        HashSet<Object> rhsValues = new HashSet<Object>(Converters.flattenArray(evaluationContext, this.rhs, Collections.emptyList()));
        log.debug("LHS: {}", lhsValues);
        log.debug("RHS: {}", rhsValues);
        return new BooleanValue(!Sets.intersection(lhsValues, rhsValues).isEmpty());
    }
}

