/*
 * Decompiled with CFR 0.152.
 */
package io.appform.shaded.org.reflections.scanners;

import io.appform.shaded.org.reflections.Store;
import io.appform.shaded.org.reflections.adapters.MetadataAdapter;
import io.appform.shaded.org.reflections.scanners.AbstractScanner;
import java.util.List;

public class MethodParameterScanner
extends AbstractScanner {
    @Override
    public void scan(Object cls, Store store) {
        MetadataAdapter md = this.getMetadataAdapter();
        for (Object method : md.getMethods(cls)) {
            String returnTypeName;
            String signature = md.getParameterNames(method).toString();
            if (this.acceptResult(signature)) {
                this.put(store, signature, md.getMethodFullKey(cls, method));
            }
            if (this.acceptResult(returnTypeName = md.getReturnTypeName(method))) {
                this.put(store, returnTypeName, md.getMethodFullKey(cls, method));
            }
            List<String> parameterNames = md.getParameterNames(method);
            for (int i = 0; i < parameterNames.size(); ++i) {
                for (String paramAnnotation : md.getParameterAnnotationNames(method, i)) {
                    if (!this.acceptResult(paramAnnotation)) continue;
                    this.put(store, paramAnnotation, md.getMethodFullKey(cls, method));
                }
            }
        }
    }
}

