/*
 * Decompiled with CFR 0.152.
 */
package io.appform.hope.core.visitors;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import io.appform.hope.core.Evaluatable;
import io.appform.hope.core.VisitorAdapter;
import io.appform.hope.core.combiners.AndCombiner;
import io.appform.hope.core.combiners.OrCombiner;
import io.appform.hope.core.exceptions.errorstrategy.DefaultErrorHandlingStrategy;
import io.appform.hope.core.exceptions.errorstrategy.ErrorHandlingStrategy;
import io.appform.hope.core.operators.And;
import io.appform.hope.core.operators.Equals;
import io.appform.hope.core.operators.Greater;
import io.appform.hope.core.operators.GreaterEquals;
import io.appform.hope.core.operators.Lesser;
import io.appform.hope.core.operators.LesserEquals;
import io.appform.hope.core.operators.Not;
import io.appform.hope.core.operators.NotEquals;
import io.appform.hope.core.operators.Or;
import io.appform.hope.core.utils.Converters;
import io.appform.hope.core.values.JsonPointerValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Evaluator {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final ParseContext parseContext;
    private final ErrorHandlingStrategy errorHandlingStrategy;

    public Evaluator() {
        this(new DefaultErrorHandlingStrategy());
    }

    public Evaluator(ErrorHandlingStrategy errorHandlingStrategy) {
        this.errorHandlingStrategy = errorHandlingStrategy;
        this.parseContext = JsonPath.using((Configuration)Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build());
    }

    public boolean evaluate(Evaluatable evaluatable, JsonNode node) {
        return evaluatable.accept(new LogicEvaluator(new EvaluationContext(this.parseContext.parse((Object)node), node, this)));
    }

    public List<Boolean> evaluate(List<Evaluatable> evaluatables, JsonNode node) {
        LogicEvaluator logicEvaluator = new LogicEvaluator(new EvaluationContext(this.parseContext.parse((Object)node), node, this));
        return evaluatables.stream().map(evaluatable -> evaluatable.accept(logicEvaluator)).collect(Collectors.toList());
    }

    public OptionalInt evaluateFirst(List<Evaluatable> rules, JsonNode node) {
        LogicEvaluator logicEvaluator = new LogicEvaluator(new EvaluationContext(this.parseContext.parse((Object)node), node, this));
        return IntStream.range(0, rules.size()).filter(index -> ((Evaluatable)rules.get(index)).accept(logicEvaluator)).findFirst();
    }

    public ErrorHandlingStrategy getErrorHandlingStrategy() {
        return this.errorHandlingStrategy;
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static class LogicEvaluator
    extends VisitorAdapter<Boolean> {
        private final EvaluationContext evaluationContext;

        public LogicEvaluator(EvaluationContext evaluationContext) {
            super(() -> true);
            this.evaluationContext = evaluationContext;
        }

        public boolean evaluate(Evaluatable evaluatable) {
            return evaluatable.accept(this);
        }

        @Override
        public Boolean visit(AndCombiner andCombiner) {
            List<Evaluatable> expressions = andCombiner.getExpressions();
            for (Evaluatable expression : expressions) {
                if (expression.accept(this).booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visit(OrCombiner orCombiner) {
            List<Evaluatable> expressions = orCombiner.getExpressions();
            for (Evaluatable expression : expressions) {
                if (!expression.accept(this).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visit(Equals equals) {
            Object lhs = Converters.objectValue(this.evaluationContext, equals.getLhs(), null);
            Object rhs = Converters.objectValue(this.evaluationContext, equals.getRhs(), null);
            return Objects.equals(lhs, rhs);
        }

        @Override
        public Boolean visit(NotEquals notEquals) {
            Object rhs;
            Object lhs = Converters.objectValue(this.evaluationContext, notEquals.getLhs(), null);
            return !Objects.equals(lhs, rhs = Converters.objectValue(this.evaluationContext, notEquals.getRhs(), null));
        }

        @Override
        public Boolean visit(Greater greater) {
            Number lhs = Converters.numericValue(this.evaluationContext, greater.getLhs(), 0);
            Number rhs = Converters.numericValue(this.evaluationContext, greater.getRhs(), 0);
            return lhs.doubleValue() > rhs.doubleValue();
        }

        @Override
        public Boolean visit(GreaterEquals greaterEquals) {
            Number lhs = Converters.numericValue(this.evaluationContext, greaterEquals.getLhs(), 0);
            Number rhs = Converters.numericValue(this.evaluationContext, greaterEquals.getRhs(), 0);
            return lhs.doubleValue() >= rhs.doubleValue();
        }

        @Override
        public Boolean visit(Lesser lesser) {
            Number lhs = Converters.numericValue(this.evaluationContext, lesser.getLhs(), 0);
            Number rhs = Converters.numericValue(this.evaluationContext, lesser.getRhs(), 0);
            return lhs.doubleValue() < rhs.doubleValue();
        }

        @Override
        public Boolean visit(LesserEquals lesserEquals) {
            Number lhs = Converters.numericValue(this.evaluationContext, lesserEquals.getLhs(), 0);
            Number rhs = Converters.numericValue(this.evaluationContext, lesserEquals.getRhs(), 0);
            return lhs.doubleValue() <= rhs.doubleValue();
        }

        @Override
        public Boolean visit(And and) {
            boolean lhs = Converters.booleanValue(this.evaluationContext, and.getLhs(), false);
            boolean rhs = Converters.booleanValue(this.evaluationContext, and.getRhs(), false);
            return lhs && rhs;
        }

        @Override
        public Boolean visit(Or or) {
            boolean lhs = Converters.booleanValue(this.evaluationContext, or.getLhs(), false);
            boolean rhs = Converters.booleanValue(this.evaluationContext, or.getRhs(), false);
            return lhs || rhs;
        }

        @Override
        public Boolean visit(Not not) {
            boolean operand = Converters.booleanValue(this.evaluationContext, not.getOperand(), false);
            return !operand;
        }

        @Override
        public Boolean visit(JsonPointerValue jsonPointerValue) {
            return null;
        }
    }

    public static class EvaluationContext {
        private final DocumentContext jsonContext;
        private final JsonNode rootNode;
        private final Evaluator evaluator;
        private final Map<String, JsonNode> jsonPathEvalCache = new HashMap<String, JsonNode>(128);
        private final Map<String, JsonNode> jsonPointerEvalCache = new HashMap<String, JsonNode>(128);

        EvaluationContext(DocumentContext jsonContext, JsonNode rootNode, Evaluator evaluator) {
            this.jsonContext = jsonContext;
            this.rootNode = rootNode;
            this.evaluator = evaluator;
        }

        public static EvaluationContextBuilder builder() {
            return new EvaluationContextBuilder();
        }

        public DocumentContext getJsonContext() {
            return this.jsonContext;
        }

        public JsonNode getRootNode() {
            return this.rootNode;
        }

        public Evaluator getEvaluator() {
            return this.evaluator;
        }

        public Map<String, JsonNode> getJsonPathEvalCache() {
            return this.jsonPathEvalCache;
        }

        public Map<String, JsonNode> getJsonPointerEvalCache() {
            return this.jsonPointerEvalCache;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EvaluationContext)) {
                return false;
            }
            EvaluationContext other = (EvaluationContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            DocumentContext this$jsonContext = this.getJsonContext();
            DocumentContext other$jsonContext = other.getJsonContext();
            if (this$jsonContext == null ? other$jsonContext != null : !this$jsonContext.equals(other$jsonContext)) {
                return false;
            }
            JsonNode this$rootNode = this.getRootNode();
            JsonNode other$rootNode = other.getRootNode();
            if (this$rootNode == null ? other$rootNode != null : !this$rootNode.equals(other$rootNode)) {
                return false;
            }
            Evaluator this$evaluator = this.getEvaluator();
            Evaluator other$evaluator = other.getEvaluator();
            if (this$evaluator == null ? other$evaluator != null : !this$evaluator.equals(other$evaluator)) {
                return false;
            }
            Map<String, JsonNode> this$jsonPathEvalCache = this.getJsonPathEvalCache();
            Map<String, JsonNode> other$jsonPathEvalCache = other.getJsonPathEvalCache();
            if (this$jsonPathEvalCache == null ? other$jsonPathEvalCache != null : !((Object)this$jsonPathEvalCache).equals(other$jsonPathEvalCache)) {
                return false;
            }
            Map<String, JsonNode> this$jsonPointerEvalCache = this.getJsonPointerEvalCache();
            Map<String, JsonNode> other$jsonPointerEvalCache = other.getJsonPointerEvalCache();
            return !(this$jsonPointerEvalCache == null ? other$jsonPointerEvalCache != null : !((Object)this$jsonPointerEvalCache).equals(other$jsonPointerEvalCache));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EvaluationContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            DocumentContext $jsonContext = this.getJsonContext();
            result = result * 59 + ($jsonContext == null ? 43 : $jsonContext.hashCode());
            JsonNode $rootNode = this.getRootNode();
            result = result * 59 + ($rootNode == null ? 43 : $rootNode.hashCode());
            Evaluator $evaluator = this.getEvaluator();
            result = result * 59 + ($evaluator == null ? 43 : $evaluator.hashCode());
            Map<String, JsonNode> $jsonPathEvalCache = this.getJsonPathEvalCache();
            result = result * 59 + ($jsonPathEvalCache == null ? 43 : ((Object)$jsonPathEvalCache).hashCode());
            Map<String, JsonNode> $jsonPointerEvalCache = this.getJsonPointerEvalCache();
            result = result * 59 + ($jsonPointerEvalCache == null ? 43 : ((Object)$jsonPointerEvalCache).hashCode());
            return result;
        }

        public String toString() {
            return "Evaluator.EvaluationContext(jsonContext=" + this.getJsonContext() + ", rootNode=" + this.getRootNode() + ", evaluator=" + this.getEvaluator() + ", jsonPathEvalCache=" + this.getJsonPathEvalCache() + ", jsonPointerEvalCache=" + this.getJsonPointerEvalCache() + ")";
        }

        public static class EvaluationContextBuilder {
            private DocumentContext jsonContext;
            private JsonNode rootNode;
            private Evaluator evaluator;

            EvaluationContextBuilder() {
            }

            public EvaluationContextBuilder jsonContext(DocumentContext jsonContext) {
                this.jsonContext = jsonContext;
                return this;
            }

            public EvaluationContextBuilder rootNode(JsonNode rootNode) {
                this.rootNode = rootNode;
                return this;
            }

            public EvaluationContextBuilder evaluator(Evaluator evaluator) {
                this.evaluator = evaluator;
                return this;
            }

            public EvaluationContext build() {
                return new EvaluationContext(this.jsonContext, this.rootNode, this.evaluator);
            }

            public String toString() {
                return "Evaluator.EvaluationContext.EvaluationContextBuilder(jsonContext=" + this.jsonContext + ", rootNode=" + this.rootNode + ", evaluator=" + this.evaluator + ")";
            }
        }
    }
}

