/*
 * Decompiled with CFR 0.152.
 */
package io.appform.hope.core.values;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.appform.hope.core.Visitor;
import io.appform.hope.core.values.FunctionEvaluatableValue;
import io.appform.hope.core.values.FunctionValue;
import java.util.Objects;

public class JsonPathValue
extends FunctionEvaluatableValue {
    private final String path;
    private final JsonPath jsonPath;

    public JsonPathValue(String path) {
        this.path = path;
        this.jsonPath = JsonPath.compile((String)path, (Predicate[])new Predicate[0]);
    }

    public JsonPathValue(FunctionValue function) {
        super(function);
        this.path = null;
        this.jsonPath = null;
    }

    @Override
    public <T> T accept(Visitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        JsonPathValue other = (JsonPathValue)obj;
        return Objects.equals(this.getPath(), other.getPath());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.getPath());
    }

    public String getPath() {
        return this.path;
    }

    public JsonPath getJsonPath() {
        return this.jsonPath;
    }

    @Override
    public String toString() {
        return "JsonPathValue(super=" + super.toString() + ", path=" + this.getPath() + ", jsonPath=" + this.getJsonPath() + ")";
    }
}

