/*
 * Decompiled with CFR 0.152.
 */
package io.appform.hope.core.values;

import io.appform.hope.core.values.FunctionEvaluatableValue;
import io.appform.hope.core.values.FunctionValue;
import io.appform.hope.core.values.JsonPathValue;
import io.appform.hope.core.values.JsonPointerValue;

public abstract class EvaluatableValue<T>
extends FunctionEvaluatableValue {
    private final T value;
    private final JsonPathValue pathValue;
    private final JsonPointerValue pointerValue;

    protected EvaluatableValue(T value) {
        this.value = value;
        this.pathValue = null;
        this.pointerValue = null;
    }

    protected EvaluatableValue(JsonPathValue pathValue) {
        this.value = null;
        this.pathValue = pathValue;
        this.pointerValue = null;
    }

    protected EvaluatableValue(JsonPointerValue pointerValue) {
        this.value = null;
        this.pathValue = null;
        this.pointerValue = pointerValue;
    }

    protected EvaluatableValue(FunctionValue function) {
        super(function);
        this.value = null;
        this.pathValue = null;
        this.pointerValue = null;
    }

    public T getValue() {
        return this.value;
    }

    public JsonPathValue getPathValue() {
        return this.pathValue;
    }

    public JsonPointerValue getPointerValue() {
        return this.pointerValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EvaluatableValue)) {
            return false;
        }
        EvaluatableValue other = (EvaluatableValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        JsonPathValue this$pathValue = this.getPathValue();
        JsonPathValue other$pathValue = other.getPathValue();
        if (this$pathValue == null ? other$pathValue != null : !((Object)this$pathValue).equals(other$pathValue)) {
            return false;
        }
        JsonPointerValue this$pointerValue = this.getPointerValue();
        JsonPointerValue other$pointerValue = other.getPointerValue();
        return !(this$pointerValue == null ? other$pointerValue != null : !((Object)this$pointerValue).equals(other$pointerValue));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EvaluatableValue;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        JsonPathValue $pathValue = this.getPathValue();
        result = result * 59 + ($pathValue == null ? 43 : ((Object)$pathValue).hashCode());
        JsonPointerValue $pointerValue = this.getPointerValue();
        result = result * 59 + ($pointerValue == null ? 43 : ((Object)$pointerValue).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "EvaluatableValue(super=" + super.toString() + ", value=" + this.getValue() + ", pathValue=" + this.getPathValue() + ", pointerValue=" + this.getPointerValue() + ")";
    }
}

