/*
 * Decompiled with CFR 0.152.
 */
package io.appform.hope.core.functions.impl.utils;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.appform.hope.core.Value;
import io.appform.hope.core.functions.FunctionImplementation;
import io.appform.hope.core.functions.HopeFunction;
import io.appform.hope.core.utils.Converters;
import io.appform.hope.core.utils.RawTypeHandler;
import io.appform.hope.core.values.NumericValue;
import io.appform.hope.core.visitors.Evaluator;
import java.nio.charset.Charset;

@FunctionImplementation(value="utils.hash_m128")
public class HashM128
extends HopeFunction<NumericValue> {
    private final Value arg;

    public HashM128(Value arg) {
        this.arg = arg;
    }

    @Override
    public NumericValue apply(Evaluator.EvaluationContext evaluationContext) {
        final Hasher hasher = Hashing.murmur3_128().newHasher();
        long hashValue = Converters.handleValue(evaluationContext, this.arg, "", new RawTypeHandler<Hasher>(){

            @Override
            public Hasher handleString(String s) {
                return hasher.putString((CharSequence)s, Charset.defaultCharset());
            }

            @Override
            public Hasher handleBoolean(boolean b) {
                return hasher.putBoolean(b);
            }

            @Override
            public Hasher handleNumber(Number n) {
                return hasher.putDouble(n.doubleValue());
            }

            @Override
            public Hasher handleObject(Object o) {
                return hasher.putString((CharSequence)HashM128.this.arg.toString(), Charset.defaultCharset());
            }
        }).hash().asLong();
        return new NumericValue(hashValue);
    }
}

