/*
 * Decompiled with CFR 0.152.
 */
package io.appform.functionmetrics;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;

public class Options {
    private boolean enableParameterCapture;
    private Converter<String, String> caseFormatConverter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
    private boolean disableCacheOptimisation;

    public boolean isEnableParameterCapture() {
        return this.enableParameterCapture;
    }

    public Converter<String, String> getCaseFormatConverter() {
        return this.caseFormatConverter;
    }

    public boolean isDisableCacheOptimisation() {
        return this.disableCacheOptimisation;
    }

    public static class OptionsBuilder {
        private boolean enableParameterCapture;
        private Converter<String, String> caseFormatConverter;
        private boolean disableCacheOptimisation;

        public OptionsBuilder enableParameterCapture(boolean enableParameterCapture) {
            this.enableParameterCapture = enableParameterCapture;
            return this;
        }

        public OptionsBuilder caseFormatConverter(Converter<String, String> caseFormatConverter) {
            this.caseFormatConverter = caseFormatConverter;
            return this;
        }

        public OptionsBuilder disableCacheOptimisation() {
            return this.disableCacheOptimisation(true);
        }

        public OptionsBuilder disableCacheOptimisation(boolean disableCacheOptimisation) {
            this.disableCacheOptimisation = disableCacheOptimisation;
            return this;
        }

        public Options build() {
            Options options = new Options();
            if (this.caseFormatConverter != null) {
                options.caseFormatConverter = this.caseFormatConverter;
            }
            options.enableParameterCapture = this.enableParameterCapture;
            options.disableCacheOptimisation = this.disableCacheOptimisation;
            return options;
        }
    }
}

