/*
 * Decompiled with CFR 0.152.
 */
package io.appform.functionmetrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import com.codahale.metrics.Timer;
import com.google.common.base.Strings;
import io.appform.functionmetrics.FunctionInvocation;
import io.appform.functionmetrics.Options;
import io.appform.functionmetrics.TimerDomain;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionMetricsManager {
    private static final Logger log = LoggerFactory.getLogger((String)FunctionMetricsManager.class.getSimpleName());
    private static MetricRegistry registry;
    private static String prefix;
    private static Options options;

    public static Optional<Options> getOptions() {
        return Optional.ofNullable(options);
    }

    private FunctionMetricsManager() {
    }

    public static void initialize(String packageName, MetricRegistry registry) {
        FunctionMetricsManager.initialize(packageName, registry, new Options());
    }

    public static void initialize(String packageName, MetricRegistry registry, Options options) {
        log.info("Functional Metric prefix: {}", (Object)packageName);
        FunctionMetricsManager.registry = registry;
        prefix = packageName;
        FunctionMetricsManager.options = options;
    }

    public static Optional<Timer> timer(TimerDomain domain, FunctionInvocation invocation) {
        if (registry == null) {
            log.warn("Please call FunctionalMetricsManager.initialize() to setup metrics collection. No metrics will be pushed.");
            return Optional.empty();
        }
        MetricRegistry.MetricSupplier metricSupplier = () -> new Timer((Reservoir)new SlidingTimeWindowArrayReservoir(60L, TimeUnit.SECONDS));
        if (options.isEnableParameterCapture() && !Strings.isNullOrEmpty((String)invocation.getParameterString())) {
            return Optional.of(registry.timer(String.format("%s.%s.%s.%s.%s", prefix, invocation.getClassName(), invocation.getMethodName(), invocation.getParameterString(), domain.getValue()), metricSupplier));
        }
        return Optional.of(registry.timer(String.format("%s.%s.%s.%s", prefix, invocation.getClassName(), invocation.getMethodName(), domain.getValue()), metricSupplier));
    }
}

