/*
 * Decompiled with CFR 0.152.
 */
package io.appform.functionmetrics;

import com.codahale.metrics.Timer;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import io.appform.functionmetrics.FunctionInvocation;
import io.appform.functionmetrics.FunctionMetricConstants;
import io.appform.functionmetrics.FunctionMetricsManager;
import io.appform.functionmetrics.MethodData;
import io.appform.functionmetrics.MetricTerm;
import io.appform.functionmetrics.MonitoredFunction;
import io.appform.functionmetrics.Options;
import io.appform.functionmetrics.Pair;
import io.appform.functionmetrics.TimerDomain;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class FunctionTimerAspect {
    private static final Logger log = LoggerFactory.getLogger((String)FunctionTimerAspect.class.getName());
    private final Map<String, MethodData> paramCache = new ConcurrentHashMap<String, MethodData>();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ FunctionTimerAspect ajc$perSingletonInstance;

    static {
        try {
            FunctionTimerAspect.ajc$perSingletonInstance = new FunctionTimerAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="@annotation(io.appform.functionmetrics.MonitoredFunction)")
    public /* synthetic */ void monitoredFunctionCalled() {
    }

    @Pointcut(value="execution(* *(..))")
    public /* synthetic */ void anyFunctionCalled() {
    }

    @Around(value="monitoredFunctionCalled() && anyFunctionCalled()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Signature callSignature = joinPoint.getSignature();
        MethodData methodData = this.getMethodData(joinPoint, callSignature);
        FunctionInvocation invocation = this.createFunctionInvocation(methodData, joinPoint, callSignature);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            Object response = joinPoint.proceed();
            stopwatch.stop();
            FunctionMetricsManager.timer(TimerDomain.SUCCESS, invocation).ifPresent(timer -> this.updateTimer((Timer)timer, stopwatch));
            Object object = response;
            return object;
        }
        catch (Throwable t) {
            stopwatch.stop();
            FunctionMetricsManager.timer(TimerDomain.FAILURE, invocation).ifPresent(timer -> this.updateTimer((Timer)timer, stopwatch));
            throw t;
        }
        finally {
            FunctionMetricsManager.timer(TimerDomain.ALL, invocation).ifPresent(timer -> this.updateTimer((Timer)timer, stopwatch));
        }
    }

    private boolean cacheDisabled() {
        return FunctionMetricsManager.getOptions().map(Options::isDisableCacheOptimisation).orElse(false);
    }

    private boolean parameterCaptureEnabled() {
        return FunctionMetricsManager.getOptions().map(Options::isEnableParameterCapture).orElse(false);
    }

    private MethodData getMethodData(ProceedingJoinPoint joinPoint, Signature callSignature) {
        return this.cacheDisabled() ? this.createMethodData(joinPoint, callSignature) : this.paramCache.computeIfAbsent(callSignature.toLongString(), key -> this.createMethodData(joinPoint, callSignature));
    }

    private MethodData createMethodData(ProceedingJoinPoint joinPoint, Signature callSignature) {
        MethodSignature methodSignature = (MethodSignature)callSignature;
        MonitoredFunction monitoredFunction = methodSignature.getMethod().getAnnotation(MonitoredFunction.class);
        String className = Strings.isNullOrEmpty((String)monitoredFunction.className()) ? callSignature.getDeclaringType().getSimpleName() : monitoredFunction.className();
        String methodName = Strings.isNullOrEmpty((String)monitoredFunction.method()) ? callSignature.getName() : monitoredFunction.method();
        boolean isParameterCaptureEnabled = this.parameterCaptureEnabled();
        return new MethodData(className, methodName, isParameterCaptureEnabled ? this.getAnnotatedParamPositions(methodSignature) : Collections.emptyList());
    }

    private FunctionInvocation createFunctionInvocation(MethodData methodData, ProceedingJoinPoint joinPoint, Signature callSignature) {
        MethodSignature cfr_ignored_0 = (MethodSignature)callSignature;
        Options cfr_ignored_1 = FunctionMetricsManager.getOptions().orElse(null);
        String className = methodData.getClassName();
        String methodName = methodData.getMethodName();
        String parameterString = !methodData.getParameterPositions().isEmpty() ? this.getParamString(joinPoint, methodData.getParameterPositions()).orElse("") : "";
        log.trace("Called for class: {} method: {} parameterString: {}", new Object[]{className, methodName, parameterString});
        return new FunctionInvocation(className, methodName, parameterString);
    }

    private boolean isParamCaptureRequired(MethodSignature methodSignature) {
        return IntStream.range(0, methodSignature.getMethod().getParameterCount()).anyMatch(i -> methodSignature.getMethod().getParameters()[i].getAnnotation(MetricTerm.class) != null);
    }

    private String getParamValueAtPos(ProceedingJoinPoint joinPoint, int pos) {
        if (pos >= joinPoint.getArgs().length) {
            log.warn("Unusual scenario: parameter position {} is >= args length {}", (Object)pos, (Object)joinPoint.getArgs().length);
            return "";
        }
        String paramValueStr = this.convertToString(joinPoint.getArgs()[pos]).trim();
        return FunctionMetricConstants.VALID_PARAM_VALUE_PATTERN.matcher(paramValueStr).matches() ? FunctionMetricsManager.getOptions().map(options -> (String)options.getCaseFormatConverter().convert((Object)paramValueStr)).orElse("") : "";
    }

    private List<Integer> getAnnotatedParamPositions(MethodSignature methodSignature) {
        return IntStream.range(0, methodSignature.getMethod().getParameterCount()).mapToObj(i -> {
            MetricTerm metricTerm = methodSignature.getMethod().getParameters()[i].getAnnotation(MetricTerm.class);
            if (metricTerm == null) {
                return null;
            }
            return new Pair<Integer, Integer>(metricTerm.order(), i);
        }).filter(Objects::nonNull).sorted(Comparator.comparingInt(Pair::getKey)).map(Pair::getValue).collect(Collectors.toList());
    }

    private Optional<String> getParamString(ProceedingJoinPoint joinPoint, List<Integer> paramPositions) {
        if (!this.parameterCaptureEnabled()) {
            return Optional.empty();
        }
        List paramValues = paramPositions.stream().map(pos -> this.getParamValueAtPos(joinPoint, (int)pos)).collect(Collectors.toList());
        if (paramValues.stream().noneMatch(Strings::isNullOrEmpty)) {
            return Optional.of(Joiner.on((String)".").join(paramValues));
        }
        return Optional.empty();
    }

    private void updateTimer(Timer timer, Stopwatch stopwatch) {
        timer.update(stopwatch.elapsed(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    private String convertToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Enum) {
            return ((Enum)obj).name();
        }
        return "";
    }

    public static FunctionTimerAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("io.appform.functionmetrics.FunctionTimerAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

