/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.metrics;

import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableList;
import io.appform.dropwizard.sharding.execution.TransactionExecutionContext;
import io.appform.dropwizard.sharding.metrics.EntityOpMetricKey;
import io.appform.dropwizard.sharding.metrics.MetricData;
import io.appform.dropwizard.sharding.metrics.TransactionMetricManager;
import io.appform.dropwizard.sharding.observers.TransactionObserver;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;

public class TransactionMetricObserver
extends TransactionObserver {
    private final TransactionMetricManager metricManager;
    private final Map<EntityOpMetricKey, MetricData> entityOpMetricCache = new ConcurrentHashMap<EntityOpMetricKey, MetricData>();
    private final Map<String, MetricData> shardMetricCache = new ConcurrentHashMap<String, MetricData>();

    public TransactionMetricObserver(TransactionMetricManager metricManager) {
        super(null);
        this.metricManager = metricManager;
    }

    @Override
    public <T> T execute(TransactionExecutionContext context, Supplier<T> supplier) {
        if (!this.metricManager.isMetricApplicable(context.getEntityClass())) {
            return this.proceed(context, supplier);
        }
        List<MetricData> metrics = this.getMetrics(context);
        List<Timer.Context> timerContexts = metrics.stream().map(metric -> metric.getTimer().time()).collect(Collectors.toList());
        metrics.forEach(metric -> metric.getTotal().mark());
        try {
            T response = this.proceed(context, supplier);
            metrics.forEach(metric -> metric.getSuccess().mark());
            T t = response;
            return t;
        }
        catch (Throwable t) {
            metrics.forEach(metric -> metric.getFailed().mark());
            throw t;
        }
        finally {
            timerContexts.forEach(Timer.Context::stop);
        }
    }

    private List<MetricData> getMetrics(TransactionExecutionContext context) {
        MetricData entityOpMetricData = this.entityOpMetricCache.computeIfAbsent(EntityOpMetricKey.builder().lockedContextMode(context.getLockedContextMode()).opType(context.getOpType()).daoClass(context.getDaoClass()).entityClass(context.getEntityClass()).build(), key -> this.metricManager.getEntityOpMetricData(context));
        MetricData shardMetricData = this.shardMetricCache.computeIfAbsent(context.getShardName(), key -> this.metricManager.getShardMetricData(context.getShardName()));
        return ImmutableList.of((Object)entityOpMetricData, (Object)shardMetricData);
    }

    @Generated
    public Map<EntityOpMetricKey, MetricData> getEntityOpMetricCache() {
        return this.entityOpMetricCache;
    }

    @Generated
    public Map<String, MetricData> getShardMetricCache() {
        return this.shardMetricCache;
    }
}

