/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingTimeWindowArrayReservoir;
import com.codahale.metrics.Timer;
import com.google.common.base.Strings;
import io.appform.dropwizard.sharding.config.MetricConfig;
import io.appform.dropwizard.sharding.execution.TransactionExecutionContext;
import io.appform.dropwizard.sharding.metrics.MetricData;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class TransactionMetricManager {
    private static final String METRIC_PREFIX = "db.sharding";
    private static final String DELIMITER = ".";
    private static final String DELIMITER_REPLACEMENT = "_";
    private final Supplier<MetricConfig> metricConfigSupplier;
    private final MetricRegistry metricRegistry;

    public TransactionMetricManager(Supplier<MetricConfig> metricConfigSupplier, MetricRegistry metricRegistry) {
        this.metricConfigSupplier = metricConfigSupplier;
        this.metricRegistry = metricRegistry;
    }

    public boolean isMetricApplicable(Class<?> entityClass) {
        if (this.metricConfigSupplier == null) {
            return false;
        }
        MetricConfig metricConfig = this.metricConfigSupplier.get();
        if (metricConfig == null) {
            return false;
        }
        if (metricConfig.isEnabledForAll()) {
            return true;
        }
        return metricConfig.getEnabledForEntities() != null && metricConfig.getEnabledForEntities().contains(entityClass.getCanonicalName());
    }

    public MetricData getShardMetricData(String shardName) {
        String metricPrefix = this.getMetricPrefix("shard", shardName);
        return this.getMetricData(metricPrefix);
    }

    public MetricData getEntityOpMetricData(TransactionExecutionContext context) {
        String metricPrefix = this.getMetricPrefix("entity", context.getEntityClass().getCanonicalName(), context.getDaoClass().getCanonicalName(), context.getOpType(), context.getLockedContextMode());
        return this.getMetricData(metricPrefix);
    }

    private String getMetricPrefix(String ... metricNames) {
        StringBuilder metricPrefix = new StringBuilder(METRIC_PREFIX);
        for (String metricName : metricNames) {
            if (Strings.isNullOrEmpty((String)metricName)) continue;
            metricPrefix.append(DELIMITER).append(this.normalizeString(metricName));
        }
        return metricPrefix.toString();
    }

    private MetricData getMetricData(String metricPrefix) {
        return MetricData.builder().timer(this.metricRegistry.timer(MetricRegistry.name((String)metricPrefix, (String[])new String[]{"latency"}), () -> new Timer((Reservoir)new SlidingTimeWindowArrayReservoir(60L, TimeUnit.SECONDS)))).success(this.metricRegistry.meter(MetricRegistry.name((String)metricPrefix, (String[])new String[]{"success"}))).failed(this.metricRegistry.meter(MetricRegistry.name((String)metricPrefix, (String[])new String[]{"failed"}))).total(this.metricRegistry.meter(MetricRegistry.name((String)metricPrefix, (String[])new String[]{"total"}))).build();
    }

    private String normalizeString(String name) {
        return name.replace(DELIMITER, DELIMITER_REPLACEMENT);
    }
}

