/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.execution;

import io.appform.dropwizard.sharding.ShardInfoProvider;
import io.appform.dropwizard.sharding.execution.TransactionExecutionContext;
import io.appform.dropwizard.sharding.observers.TransactionObserver;
import io.appform.dropwizard.sharding.utils.TransactionHandler;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class TransactionExecutor {
    private final Class<?> daoClass;
    private final Class<?> entityClass;
    private final ShardInfoProvider shardInfoProvider;
    private final TransactionObserver observer;

    public TransactionExecutor(ShardInfoProvider shardInfoProvider, Class<?> daoClass, Class<?> entityClass, TransactionObserver observer) {
        this.daoClass = daoClass;
        this.entityClass = entityClass;
        this.shardInfoProvider = shardInfoProvider;
        this.observer = observer;
    }

    public <T, U> Optional<T> executeAndResolve(SessionFactory sessionFactory, boolean readOnly, Function<U, T> function, U arg, String opType, int shardId) {
        T result = this.execute(sessionFactory, readOnly, function, arg, opType, shardId);
        return Optional.ofNullable(result);
    }

    public <T, U> T execute(SessionFactory sessionFactory, boolean readOnly, Function<U, T> function, U arg, String opType, int shardId) {
        return (T)this.execute(sessionFactory, readOnly, function, arg, t -> t, opType, shardId);
    }

    public <T, U> T execute(SessionFactory sessionFactory, boolean readOnly, Function<U, T> function, U arg, boolean completeTransaction, String opType, int shardId) {
        return (T)this.execute(sessionFactory, readOnly, function, arg, t -> t, completeTransaction, opType, shardId);
    }

    public <T, U, V> V execute(SessionFactory sessionFactory, boolean readOnly, Function<U, T> function, U arg, Function<T, V> handler, String opType, int shardId) {
        return this.execute(sessionFactory, readOnly, function, arg, handler, true, opType, shardId);
    }

    public <T, U, V> V execute(SessionFactory sessionFactory, boolean readOnly, Function<U, T> function, U arg, Function<T, V> handler, boolean completeTransaction, String opType, int shardId) {
        return (V)this.execute(sessionFactory, readOnly, (Session session) -> {
            Object result = function.apply(arg);
            return handler.apply(result);
        }, completeTransaction, opType, shardId);
    }

    public <T> T execute(SessionFactory sessionFactory, boolean readOnly, Function<Session, T> handler, boolean completeTransaction, String opType, int shardId) {
        TransactionExecutionContext context = TransactionExecutionContext.builder().daoClass(this.daoClass).entityClass(this.entityClass).shardName(this.shardInfoProvider.shardName(shardId)).opType(opType).build();
        return (T)this.observer.execute(context, () -> {
            TransactionHandler transactionHandler = new TransactionHandler(sessionFactory, readOnly);
            if (completeTransaction) {
                transactionHandler.beforeStart();
            }
            try {
                Object result = handler.apply(transactionHandler.getSession());
                if (completeTransaction) {
                    transactionHandler.afterEnd();
                }
                return result;
            }
            catch (Exception e) {
                if (completeTransaction) {
                    transactionHandler.onError();
                }
                throw e;
            }
        });
    }
}

