/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.dao;

import com.google.common.base.Preconditions;
import io.appform.dropwizard.sharding.ShardInfoProvider;
import io.appform.dropwizard.sharding.dao.LockedContext;
import io.appform.dropwizard.sharding.dao.LookupDao;
import io.appform.dropwizard.sharding.dao.ShardedDao;
import io.appform.dropwizard.sharding.dao.UpdateOperationMeta;
import io.appform.dropwizard.sharding.execution.TransactionExecutor;
import io.appform.dropwizard.sharding.observers.TransactionObserver;
import io.appform.dropwizard.sharding.utils.ShardCalculator;
import io.dropwizard.hibernate.AbstractDAO;
import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.persistence.Id;
import lombok.Generated;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationalDao<T>
implements ShardedDao<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RelationalDao.class);
    private List<RelationalDaoPriv> daos;
    private final Class<T> entityClass;
    private final ShardCalculator<String> shardCalculator;
    private final Field keyField;
    private final TransactionExecutor transactionExecutor;
    private final ShardInfoProvider shardInfoProvider;
    private final TransactionObserver observer;

    public RelationalDao(List<SessionFactory> sessionFactories, Class<T> entityClass, ShardCalculator<String> shardCalculator, ShardInfoProvider shardInfoProvider, TransactionObserver observer) {
        this.shardCalculator = shardCalculator;
        this.daos = sessionFactories.stream().map(x$0 -> new RelationalDaoPriv((SessionFactory)x$0)).collect(Collectors.toList());
        this.entityClass = entityClass;
        this.shardInfoProvider = shardInfoProvider;
        this.observer = observer;
        this.transactionExecutor = new TransactionExecutor(shardInfoProvider, this.getClass(), entityClass, observer);
        Field[] fields = FieldUtils.getFieldsWithAnnotation(entityClass, Id.class);
        Preconditions.checkArgument((fields.length != 0 ? 1 : 0) != 0, (Object)"A field needs to be designated as @Id");
        Preconditions.checkArgument((fields.length == 1 ? 1 : 0) != 0, (Object)"Only one field can be designated as @Id");
        this.keyField = fields[0];
        if (!this.keyField.isAccessible()) {
            try {
                this.keyField.setAccessible(true);
            }
            catch (SecurityException e) {
                log.error("Error making key field accessible please use a public method and mark that as @Id", (Throwable)e);
                throw new IllegalArgumentException("Invalid class, DAO cannot be created.", e);
            }
        }
    }

    public Optional<T> get(String parentKey, Object key) throws Exception {
        return Optional.ofNullable(this.get(parentKey, key, t -> t));
    }

    public <U> U get(String parentKey, Object key, Function<T, U> function) {
        int shardId = this.shardCalculator.shardId(parentKey);
        RelationalDaoPriv dao = this.daos.get(shardId);
        return this.transactionExecutor.execute(dao.sessionFactory, true, dao::get, key, function, "get", shardId);
    }

    public Optional<T> save(String parentKey, T entity) throws Exception {
        return Optional.ofNullable(this.save(parentKey, entity, (T t) -> t));
    }

    public <U> U save(String parentKey, T entity, Function<T, U> handler) {
        int shardId = this.shardCalculator.shardId(parentKey);
        RelationalDaoPriv dao = this.daos.get(shardId);
        return this.transactionExecutor.execute(dao.sessionFactory, false, dao::save, entity, handler, "save", shardId);
    }

    public boolean saveAll(String parentKey, Collection<T> entities) {
        int shardId = this.shardCalculator.shardId(parentKey);
        RelationalDaoPriv dao = this.daos.get(shardId);
        return this.transactionExecutor.execute(dao.sessionFactory, false, dao::saveAll, entities, "saveAll", shardId);
    }

    <U> void save(LockedContext<U> context, T entity) {
        RelationalDaoPriv dao = this.daos.get(context.getShardId());
        this.transactionExecutor.execute(context.getSessionFactory(), false, dao::save, entity, t -> t, false, "save", context.getShardId());
    }

    <U> void save(LockedContext<U> context, T entity, Function<T, T> handler) {
        RelationalDaoPriv dao = this.daos.get(context.getShardId());
        this.transactionExecutor.execute(context.getSessionFactory(), false, dao::save, entity, handler, false, "save", context.getShardId());
    }

    <U> boolean update(LockedContext<U> context, Object id, Function<T, T> updater) {
        RelationalDaoPriv dao = this.daos.get(context.getShardId());
        return this.update(context.getShardId(), context.getSessionFactory(), dao, id, updater, false);
    }

    <U> boolean update(LockedContext<U> context, DetachedCriteria criteria, Function<T, T> updater, BooleanSupplier updateNext) {
        RelationalDaoPriv dao = this.daos.get(context.getShardId());
        try {
            ScrollParamPriv scrollParam = ScrollParamPriv.builder().criteria(criteria).build();
            return this.transactionExecutor.execute(context.getSessionFactory(), true, dao::scroll, scrollParam, scrollableResults -> {
                boolean updateNextObject = true;
                try {
                    while (scrollableResults.next() && updateNextObject) {
                        Object entity = scrollableResults.get(0);
                        if (null == entity) {
                            Boolean bl = false;
                            return bl;
                        }
                        Object newEntity = updater.apply(entity);
                        if (null == newEntity) {
                            Boolean bl = false;
                            return bl;
                        }
                        dao.update(entity, newEntity);
                        updateNextObject = updateNext.getAsBoolean();
                    }
                }
                finally {
                    scrollableResults.close();
                }
                return true;
            }, false, "update", context.getShardId());
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating entity with scroll: " + criteria, e);
        }
    }

    <U> List<T> select(LookupDao.ReadOnlyContext<U> context, DetachedCriteria criteria, int first, int numResults) throws Exception {
        RelationalDaoPriv dao = this.daos.get(context.getShardId());
        SelectParamPriv selectParam = SelectParamPriv.builder().criteria(criteria).start(first).numRows(numResults).build();
        return this.transactionExecutor.execute(context.getSessionFactory(), true, dao::select, selectParam, t -> t, false, "select", context.getShardId());
    }

    public boolean update(String parentKey, Object id, Function<T, T> updater) {
        int shardId = this.shardCalculator.shardId(parentKey);
        RelationalDaoPriv dao = this.daos.get(shardId);
        return this.update(shardId, dao.sessionFactory, dao, id, updater, true);
    }

    public <U> U runInSession(String id, Function<Session, U> handler) {
        int shardId = this.shardCalculator.shardId(id);
        RelationalDaoPriv dao = this.daos.get(shardId);
        return this.transactionExecutor.execute(dao.sessionFactory, true, handler, true, "runInSession", shardId);
    }

    private boolean update(int shardId, SessionFactory daoSessionFactory, RelationalDaoPriv dao, Object id, Function<T, T> updater, boolean completeTransaction) {
        try {
            return this.transactionExecutor.execute(daoSessionFactory, true, dao::get, id, entity -> {
                if (null == entity) {
                    return false;
                }
                Object newEntity = updater.apply(entity);
                if (null == newEntity) {
                    return false;
                }
                dao.update(entity, newEntity);
                return true;
            }, completeTransaction, "update", shardId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating entity: " + id, e);
        }
    }

    public boolean update(String parentKey, DetachedCriteria criteria, Function<T, T> updater) {
        int shardId = this.shardCalculator.shardId(parentKey);
        RelationalDaoPriv dao = this.daos.get(shardId);
        try {
            SelectParamPriv selectParam = SelectParamPriv.builder().criteria(criteria).start(0).numRows(1).build();
            return this.transactionExecutor.execute(dao.sessionFactory, true, dao::select, selectParam, entityList -> {
                if (entityList == null || entityList.isEmpty()) {
                    return false;
                }
                Object oldEntity = entityList.get(0);
                if (null == oldEntity) {
                    return false;
                }
                Object newEntity = updater.apply(oldEntity);
                if (null == newEntity) {
                    return false;
                }
                dao.update(oldEntity, newEntity);
                return true;
            }, "update", shardId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating entity with criteria: " + criteria, e);
        }
    }

    public int updateUsingQuery(String parentKey, UpdateOperationMeta updateOperationMeta) {
        int shardId = this.shardCalculator.shardId(parentKey);
        RelationalDaoPriv dao = this.daos.get(shardId);
        return this.transactionExecutor.execute(dao.sessionFactory, false, dao::update, updateOperationMeta, "updateUsingQuery", shardId);
    }

    public <U> int updateUsingQuery(LockedContext<U> lockedContext, UpdateOperationMeta updateOperationMeta) {
        RelationalDaoPriv dao = this.daos.get(lockedContext.getShardId());
        return this.transactionExecutor.execute(lockedContext.getSessionFactory(), false, dao::update, updateOperationMeta, false, "updateUsingQuery", lockedContext.getShardId());
    }

    public LockedContext<T> lockAndGetExecutor(String parentKey, DetachedCriteria criteria) {
        int shardId = this.shardCalculator.shardId(parentKey);
        RelationalDaoPriv dao = this.daos.get(shardId);
        return new LockedContext<Object>(shardId, dao.sessionFactory, () -> dao.getLockedForWrite(criteria), this.entityClass, this.shardInfoProvider, this.observer);
    }

    public LockedContext<T> saveAndGetExecutor(String parentKey, T entity) {
        int shardId = this.shardCalculator.shardId(parentKey);
        RelationalDaoPriv dao = this.daos.get(shardId);
        return new LockedContext<Object>(shardId, dao.sessionFactory, dao::save, entity, this.entityClass, this.shardInfoProvider, this.observer);
    }

    <U> boolean createOrUpdate(LockedContext<U> context, DetachedCriteria criteria, Function<T, T> updater, Supplier<T> entityGenerator) {
        RelationalDaoPriv dao = this.daos.get(context.getShardId());
        try {
            SelectParamPriv selectParam = SelectParamPriv.builder().criteria(criteria).start(0).numRows(1).build();
            return this.transactionExecutor.execute(context.getSessionFactory(), true, dao::select, selectParam, entityList -> {
                if (entityList == null || entityList.isEmpty()) {
                    Preconditions.checkNotNull((Object)entityGenerator, (Object)"Entity generator can't be null");
                    Object newEntity = entityGenerator.get();
                    Preconditions.checkNotNull(newEntity, (Object)"Generated entity can't be null");
                    dao.save(newEntity);
                    return true;
                }
                Object oldEntity = entityList.get(0);
                if (null == oldEntity) {
                    return false;
                }
                Object newEntity = updater.apply(oldEntity);
                if (null == newEntity) {
                    return false;
                }
                dao.update(oldEntity, newEntity);
                return true;
            }, false, "createOrUpdate", context.getShardId());
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating entity with criteria: " + criteria, e);
        }
    }

    public boolean updateAll(String parentKey, int start, int numRows, DetachedCriteria criteria, Function<T, T> updater) {
        int shardId = this.shardCalculator.shardId(parentKey);
        RelationalDaoPriv dao = this.daos.get(shardId);
        try {
            SelectParamPriv selectParam = SelectParamPriv.builder().criteria(criteria).start(start).numRows(numRows).build();
            return this.transactionExecutor.execute(dao.sessionFactory, true, dao::select, selectParam, entityList -> {
                if (entityList == null || entityList.isEmpty()) {
                    return false;
                }
                for (Object oldEntity : entityList) {
                    if (null == oldEntity) {
                        return false;
                    }
                    Object newEntity = updater.apply(oldEntity);
                    if (null == newEntity) {
                        return false;
                    }
                    dao.update(oldEntity, newEntity);
                }
                return true;
            }, "updateAll", shardId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating entity with criteria: " + criteria, e);
        }
    }

    public List<T> select(String parentKey, DetachedCriteria criteria, int first, int numResults) throws Exception {
        return this.select(parentKey, criteria, first, numResults, t -> t);
    }

    public <U> U select(String parentKey, DetachedCriteria criteria, int first, int numResults, Function<List<T>, U> handler) throws Exception {
        int shardId = this.shardCalculator.shardId(parentKey);
        RelationalDaoPriv dao = this.daos.get(shardId);
        SelectParamPriv selectParam = SelectParamPriv.builder().criteria(criteria).start(first).numRows(numResults).build();
        return this.transactionExecutor.execute(dao.sessionFactory, true, dao::select, selectParam, handler, "select", shardId);
    }

    public long count(String parentKey, DetachedCriteria criteria) {
        int shardId = this.shardCalculator.shardId(parentKey);
        RelationalDaoPriv dao = this.daos.get(shardId);
        return this.transactionExecutor.execute(dao.sessionFactory, true, dao::count, criteria, "count", shardId);
    }

    public boolean exists(String parentKey, Object key) {
        int shardId = this.shardCalculator.shardId(parentKey);
        RelationalDaoPriv dao = this.daos.get(shardId);
        Optional<Object> result = this.transactionExecutor.executeAndResolve(dao.sessionFactory, true, dao::get, key, "exists", shardId);
        return result.isPresent();
    }

    public List<Long> countScatterGather(DetachedCriteria criteria) {
        return IntStream.range(0, this.daos.size()).mapToObj(shardId -> {
            RelationalDaoPriv dao = this.daos.get(shardId);
            try {
                return this.transactionExecutor.execute(dao.sessionFactory, true, dao::count, criteria, "countScatterGather", shardId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public List<T> scatterGather(DetachedCriteria criteria, int start, int numRows) {
        return IntStream.range(0, this.daos.size()).mapToObj(shardId -> {
            RelationalDaoPriv dao = this.daos.get(shardId);
            try {
                SelectParamPriv selectParam = SelectParamPriv.builder().criteria(criteria).start(start).numRows(numRows).build();
                return this.transactionExecutor.execute(dao.sessionFactory, true, dao::select, selectParam, "scatterGather", shardId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected Field getKeyField() {
        return this.keyField;
    }

    @Override
    @Generated
    public ShardCalculator<String> getShardCalculator() {
        return this.shardCalculator;
    }

    private final class RelationalDaoPriv
    extends AbstractDAO<T> {
        private final SessionFactory sessionFactory;

        public RelationalDaoPriv(SessionFactory sessionFactory) {
            super(sessionFactory);
            this.sessionFactory = sessionFactory;
        }

        T get(Object lookupKey) {
            return this.uniqueResult(this.currentSession().createCriteria(RelationalDao.this.entityClass).add((Criterion)Restrictions.eq((String)RelationalDao.this.keyField.getName(), (Object)lookupKey)).setLockMode(LockMode.READ));
        }

        T getLockedForWrite(DetachedCriteria criteria) {
            return this.uniqueResult(criteria.getExecutableCriteria(this.currentSession()).setLockMode(LockMode.UPGRADE_NOWAIT));
        }

        T save(T entity) {
            return this.persist(entity);
        }

        boolean saveAll(Collection<T> entities) {
            for (Object entity : entities) {
                this.persist(entity);
            }
            return true;
        }

        void update(T oldEntity, T entity) {
            this.currentSession().evict(oldEntity);
            this.currentSession().update(entity);
        }

        List<T> select(SelectParamPriv selectParam) {
            Criteria criteria = selectParam.criteria.getExecutableCriteria(this.currentSession());
            criteria.setFirstResult(selectParam.start);
            criteria.setMaxResults(selectParam.numRows);
            return this.list(criteria);
        }

        ScrollableResults scroll(ScrollParamPriv scrollDetails) {
            Criteria criteria = scrollDetails.getCriteria().getExecutableCriteria(this.currentSession());
            return criteria.scroll(ScrollMode.FORWARD_ONLY);
        }

        long count(DetachedCriteria criteria) {
            return (Long)criteria.getExecutableCriteria(this.currentSession()).setProjection(Projections.rowCount()).uniqueResult();
        }

        public int update(UpdateOperationMeta updateOperationMeta) {
            Query query = this.currentSession().createNamedQuery(updateOperationMeta.getQueryName());
            updateOperationMeta.getParams().forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
            return query.executeUpdate();
        }
    }

    private static class ScrollParamPriv {
        private DetachedCriteria criteria;

        @ConstructorProperties(value={"criteria"})
        @Generated
        ScrollParamPriv(DetachedCriteria criteria) {
            this.criteria = criteria;
        }

        @Generated
        public static ScrollParamPrivBuilder builder() {
            return new ScrollParamPrivBuilder();
        }

        @Generated
        public DetachedCriteria getCriteria() {
            return this.criteria;
        }

        @Generated
        public static class ScrollParamPrivBuilder {
            @Generated
            private DetachedCriteria criteria;

            @Generated
            ScrollParamPrivBuilder() {
            }

            @Generated
            public ScrollParamPrivBuilder criteria(DetachedCriteria criteria) {
                this.criteria = criteria;
                return this;
            }

            @Generated
            public ScrollParamPriv build() {
                return new ScrollParamPriv(this.criteria);
            }

            @Generated
            public String toString() {
                return "RelationalDao.ScrollParamPriv.ScrollParamPrivBuilder(criteria=" + this.criteria + ")";
            }
        }
    }

    private static class SelectParamPriv {
        DetachedCriteria criteria;
        int start;
        int numRows;

        @ConstructorProperties(value={"criteria", "start", "numRows"})
        @Generated
        SelectParamPriv(DetachedCriteria criteria, int start, int numRows) {
            this.criteria = criteria;
            this.start = start;
            this.numRows = numRows;
        }

        @Generated
        public static SelectParamPrivBuilder builder() {
            return new SelectParamPrivBuilder();
        }

        @Generated
        public static class SelectParamPrivBuilder {
            @Generated
            private DetachedCriteria criteria;
            @Generated
            private int start;
            @Generated
            private int numRows;

            @Generated
            SelectParamPrivBuilder() {
            }

            @Generated
            public SelectParamPrivBuilder criteria(DetachedCriteria criteria) {
                this.criteria = criteria;
                return this;
            }

            @Generated
            public SelectParamPrivBuilder start(int start) {
                this.start = start;
                return this;
            }

            @Generated
            public SelectParamPrivBuilder numRows(int numRows) {
                this.numRows = numRows;
                return this;
            }

            @Generated
            public SelectParamPriv build() {
                return new SelectParamPriv(this.criteria, this.start, this.numRows);
            }

            @Generated
            public String toString() {
                return "RelationalDao.SelectParamPriv.SelectParamPrivBuilder(criteria=" + this.criteria + ", start=" + this.start + ", numRows=" + this.numRows + ")";
            }
        }
    }
}

