/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.dao;

import com.google.common.collect.Lists;
import io.appform.dropwizard.sharding.ShardInfoProvider;
import io.appform.dropwizard.sharding.dao.RelationalDao;
import io.appform.dropwizard.sharding.dao.UpdateOperationMeta;
import io.appform.dropwizard.sharding.execution.TransactionExecutionContext;
import io.appform.dropwizard.sharding.observers.TransactionObserver;
import io.appform.dropwizard.sharding.utils.TransactionHandler;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.DetachedCriteria;

public class LockedContext<T> {
    private final int shardId;
    private final SessionFactory sessionFactory;
    private final List<Function<T, Void>> operations = Lists.newArrayList();
    private Supplier<T> getter;
    private Function<T, T> saver;
    private T entity;
    private final Mode mode;
    private final TransactionExecutionContext executionContext;
    private final TransactionObserver observer;

    public LockedContext(int shardId, SessionFactory sessionFactory, Supplier<T> getter, Class<T> entityClass, ShardInfoProvider shardInfoProvider, TransactionObserver observer) {
        this.shardId = shardId;
        this.sessionFactory = sessionFactory;
        this.getter = getter;
        this.observer = observer;
        this.mode = Mode.READ;
        this.executionContext = this.buildExecutionContext(shardInfoProvider, entityClass);
    }

    public LockedContext(int shardId, SessionFactory sessionFactory, Function<T, T> saver, T entity, Class<T> entityClass, ShardInfoProvider shardInfoProvider, TransactionObserver observer) {
        this.shardId = shardId;
        this.sessionFactory = sessionFactory;
        this.saver = saver;
        this.entity = entity;
        this.observer = observer;
        this.mode = Mode.INSERT;
        this.executionContext = this.buildExecutionContext(shardInfoProvider, entityClass);
    }

    public LockedContext<T> mutate(Mutator<T> mutator) {
        return this.apply(parent -> {
            mutator.mutator(parent);
            return null;
        });
    }

    public LockedContext<T> apply(Function<T, Void> handler) {
        this.operations.add(handler);
        return this;
    }

    public <U> LockedContext<T> save(RelationalDao<U> relationalDao, Function<T, U> entityGenerator) {
        return this.apply(parent -> {
            try {
                Object entity = entityGenerator.apply(parent);
                relationalDao.save(this, entity);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    public <U> LockedContext<T> saveAll(RelationalDao<U> relationalDao, Function<T, List<U>> entityGenerator) {
        return this.apply(parent -> {
            try {
                List entities = (List)entityGenerator.apply(parent);
                for (Object entity : entities) {
                    relationalDao.save(this, entity);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    public <U> LockedContext<T> save(RelationalDao<U> relationalDao, U entity, Function<U, U> handler) {
        return this.apply(parent -> {
            try {
                relationalDao.save(this, entity, handler);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    public <U> LockedContext<T> updateUsingQuery(RelationalDao<U> relationalDao, UpdateOperationMeta updateOperationMeta) {
        return this.apply(parent -> {
            try {
                relationalDao.updateUsingQuery(this, updateOperationMeta);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    public <U> LockedContext<T> update(RelationalDao<U> relationalDao, Object id, Function<U, U> handler) {
        return this.apply(parent -> {
            try {
                relationalDao.update(this, id, handler);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    public <U> LockedContext<T> createOrUpdate(RelationalDao<U> relationalDao, DetachedCriteria criteria, Function<U, U> updater, Supplier<U> entityGenerator) {
        return this.apply(parent -> {
            try {
                relationalDao.createOrUpdate(this, criteria, updater, entityGenerator);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    public <U> LockedContext<T> update(RelationalDao<U> relationalDao, DetachedCriteria criteria, Function<U, U> updater, BooleanSupplier updateNext) {
        return this.apply(parent -> {
            try {
                relationalDao.update(this, criteria, updater, updateNext);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    public LockedContext<T> filter(Predicate<T> predicate) {
        return this.filter(predicate, new IllegalArgumentException("Predicate check failed"));
    }

    public LockedContext<T> filter(Predicate<T> predicate, RuntimeException failureException) {
        return this.apply(parent -> {
            boolean result = predicate.test(parent);
            if (!result) {
                throw failureException;
            }
            return null;
        });
    }

    public T execute() {
        return (T)this.observer.execute(this.executionContext, () -> {
            TransactionHandler transactionHandler = new TransactionHandler(this.sessionFactory, false);
            transactionHandler.beforeStart();
            try {
                Object result = this.generateEntity();
                this.operations.forEach(operation -> operation.apply(result));
                Object t = result;
                return t;
            }
            catch (Exception e) {
                transactionHandler.onError();
                throw e;
            }
            finally {
                transactionHandler.afterEnd();
            }
        });
    }

    private TransactionExecutionContext buildExecutionContext(ShardInfoProvider shardInfoProvider, Class<T> entityClass) {
        return TransactionExecutionContext.builder().shardName(shardInfoProvider.shardName(this.shardId)).lockedContextMode(this.mode.name()).entityClass(entityClass).daoClass(this.getClass()).opType("execute").build();
    }

    private T generateEntity() {
        T result = null;
        switch (this.mode) {
            case READ: {
                result = this.getter.get();
                if (result != null) break;
                throw new RuntimeException("Entity doesn't exist");
            }
            case INSERT: {
                result = this.saver.apply(this.entity);
                break;
            }
        }
        return result;
    }

    @Generated
    public int getShardId() {
        return this.shardId;
    }

    @Generated
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Generated
    public List<Function<T, Void>> getOperations() {
        return this.operations;
    }

    @Generated
    public Supplier<T> getGetter() {
        return this.getter;
    }

    @Generated
    public Function<T, T> getSaver() {
        return this.saver;
    }

    @Generated
    public T getEntity() {
        return this.entity;
    }

    @Generated
    public Mode getMode() {
        return this.mode;
    }

    @Generated
    public TransactionExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Generated
    public TransactionObserver getObserver() {
        return this.observer;
    }

    static enum Mode {
        READ,
        INSERT;

    }

    @FunctionalInterface
    public static interface Mutator<T> {
        public void mutator(T var1);
    }
}

