/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.scroll;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public final class ScrollPointer
implements Serializable {
    private static final long serialVersionUID = -3317823670664673152L;
    private final Direction direction;
    private final Map<Integer, Integer> pointPerShard = new ConcurrentHashMap<Integer, Integer>();

    public ScrollPointer put(int shard, Integer offset) {
        this.pointPerShard.put(shard, offset);
        return this;
    }

    public int advance(int shard, int advanceBy) {
        return this.pointPerShard.compute(shard, (key, existing) -> (null == existing ? 0 : existing) + advanceBy);
    }

    public int getCurrOffset(int shard) {
        return this.pointPerShard.computeIfAbsent(shard, key -> 0);
    }

    @ConstructorProperties(value={"direction"})
    @Generated
    public ScrollPointer(Direction direction) {
        this.direction = direction;
    }

    @Generated
    public Direction getDirection() {
        return this.direction;
    }

    @Generated
    public Map<Integer, Integer> getPointPerShard() {
        return this.pointPerShard;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScrollPointer)) {
            return false;
        }
        ScrollPointer other = (ScrollPointer)o;
        Direction this$direction = this.getDirection();
        Direction other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !((Object)((Object)this$direction)).equals((Object)other$direction)) {
            return false;
        }
        Map<Integer, Integer> this$pointPerShard = this.getPointPerShard();
        Map<Integer, Integer> other$pointPerShard = other.getPointPerShard();
        return !(this$pointPerShard == null ? other$pointPerShard != null : !((Object)this$pointPerShard).equals(other$pointPerShard));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Direction $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : ((Object)((Object)$direction)).hashCode());
        Map<Integer, Integer> $pointPerShard = this.getPointPerShard();
        result = result * 59 + ($pointPerShard == null ? 43 : ((Object)$pointPerShard).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ScrollPointer(direction=" + (Object)((Object)this.getDirection()) + ", pointPerShard=" + this.getPointPerShard() + ")";
    }

    public static enum Direction {
        UP,
        DOWN;

    }
}

