/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.observers.internal;

import io.appform.dropwizard.sharding.execution.TransactionExecutionContext;
import io.appform.dropwizard.sharding.listeners.TransactionListener;
import io.appform.dropwizard.sharding.observers.TransactionObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ListenerTriggeringObserver
extends TransactionObserver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ListenerTriggeringObserver.class);
    private final List<TransactionListener> listeners = new ArrayList<TransactionListener>();

    public ListenerTriggeringObserver() {
        this(null);
    }

    public ListenerTriggeringObserver(TransactionObserver next) {
        super(next);
    }

    public TransactionObserver addListener(TransactionListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public TransactionObserver addListeners(Collection<TransactionListener> listeners) {
        this.listeners.addAll(listeners);
        return this;
    }

    @Override
    public final <T> T execute(TransactionExecutionContext context, Supplier<T> supplier) {
        Objects.requireNonNull(context, "Context cannot be null");
        try {
            this.listeners.forEach(listener -> {
                try {
                    listener.beforeExecute(context);
                }
                catch (Throwable t) {
                    log.info("Error running listener beforeExecute: " + listener.getClass(), t);
                }
            });
            T result = this.proceed(context, supplier);
            this.listeners.forEach(listener -> {
                try {
                    listener.afterExecute(context);
                }
                catch (Throwable t) {
                    log.info("Error running listener afterExecute: " + listener.getClass(), t);
                }
            });
            return result;
        }
        catch (Throwable t) {
            this.listeners.forEach(listener -> {
                try {
                    listener.afterException(context, t);
                }
                catch (Throwable th) {
                    log.info("Error running listener afterException: " + listener.getClass(), th);
                }
            });
            throw t;
        }
    }

    @Generated
    public List<TransactionListener> getListeners() {
        return this.listeners;
    }
}

