/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.metrics;

import com.codahale.metrics.Timer;
import com.google.common.collect.Lists;
import io.appform.dropwizard.sharding.execution.TransactionExecutionContext;
import io.appform.dropwizard.sharding.metrics.MetricData;
import io.appform.dropwizard.sharding.metrics.TransactionMetricManager;
import io.appform.dropwizard.sharding.observers.TransactionObserver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;

public class TransactionMetricObserver
extends TransactionObserver {
    private final TransactionMetricManager metricManager;
    private final Map<Class<?>, MetricData> entityMetricCache = new ConcurrentHashMap();
    private final Map<String, MetricData> shardMetricCache = new ConcurrentHashMap<String, MetricData>();
    private final Map<String, Map<String, MetricData>> daoToOpTypeMetricCache = new ConcurrentHashMap<String, Map<String, MetricData>>();
    private final Map<Class<?>, String> daoMetricPrefixCache = new ConcurrentHashMap();

    public TransactionMetricObserver(TransactionMetricManager metricManager) {
        super(null);
        this.metricManager = metricManager;
    }

    @Override
    public <T> T execute(TransactionExecutionContext context, Supplier<T> supplier) {
        if (!this.metricManager.isMetricApplicable(context.getEntityClass())) {
            return this.proceed(context, supplier);
        }
        List<MetricData> metrics = this.getMetrics(context);
        List<Timer.Context> timerContexts = metrics.stream().map(metric -> metric.getTimer().time()).collect(Collectors.toList());
        metrics.forEach(metric -> metric.getTotal().mark());
        try {
            T response = this.proceed(context, supplier);
            metrics.forEach(metric -> metric.getSuccess().mark());
            T t = response;
            return t;
        }
        catch (Throwable t) {
            metrics.forEach(metric -> metric.getFailed().mark());
            throw t;
        }
        finally {
            timerContexts.forEach(Timer.Context::stop);
        }
    }

    private List<MetricData> getMetrics(TransactionExecutionContext context) {
        MetricData entityMetricData = this.entityMetricCache.computeIfAbsent(context.getEntityClass(), key -> this.metricManager.getEntityMetricData(context.getEntityClass()));
        MetricData shardMetricData = this.shardMetricCache.computeIfAbsent(context.getShardName(), key -> this.metricManager.getShardMetricData(context.getShardName()));
        MetricData daoMetricData = this.getDaoMetricData(context);
        return Lists.newArrayList((Object[])new MetricData[]{entityMetricData, shardMetricData, daoMetricData});
    }

    private MetricData getDaoMetricData(TransactionExecutionContext context) {
        Class<?> daoClass = context.getDaoClass();
        String daoMetricPrefix = this.daoMetricPrefixCache.computeIfAbsent(daoClass, key -> {
            String prefix = this.metricManager.getDaoMetricPrefix(daoClass);
            this.daoToOpTypeMetricCache.put(prefix, new HashMap());
            return prefix;
        });
        String opType = context.getOpType();
        return this.daoToOpTypeMetricCache.get(daoMetricPrefix).computeIfAbsent(opType, key -> this.metricManager.getDaoOpMetricData(daoMetricPrefix, context));
    }

    @Generated
    public Map<Class<?>, MetricData> getEntityMetricCache() {
        return this.entityMetricCache;
    }

    @Generated
    public Map<String, MetricData> getShardMetricCache() {
        return this.shardMetricCache;
    }

    @Generated
    public Map<String, Map<String, MetricData>> getDaoToOpTypeMetricCache() {
        return this.daoToOpTypeMetricCache;
    }

    @Generated
    public Map<Class<?>, String> getDaoMetricPrefixCache() {
        return this.daoMetricPrefixCache;
    }
}

