/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.dao;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.appform.dropwizard.sharding.ShardInfoProvider;
import io.appform.dropwizard.sharding.config.ShardingBundleOptions;
import io.appform.dropwizard.sharding.dao.LockedContext;
import io.appform.dropwizard.sharding.dao.RelationalDao;
import io.appform.dropwizard.sharding.dao.ShardedDao;
import io.appform.dropwizard.sharding.dao.UpdateOperationMeta;
import io.appform.dropwizard.sharding.execution.TransactionExecutionContext;
import io.appform.dropwizard.sharding.execution.TransactionExecutor;
import io.appform.dropwizard.sharding.observers.TransactionObserver;
import io.appform.dropwizard.sharding.scroll.FieldComparator;
import io.appform.dropwizard.sharding.scroll.ScrollPointer;
import io.appform.dropwizard.sharding.scroll.ScrollResult;
import io.appform.dropwizard.sharding.scroll.ScrollResultItem;
import io.appform.dropwizard.sharding.sharding.LookupKey;
import io.appform.dropwizard.sharding.utils.InternalUtils;
import io.appform.dropwizard.sharding.utils.ShardCalculator;
import io.appform.dropwizard.sharding.utils.TransactionHandler;
import io.dropwizard.hibernate.AbstractDAO;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupDao<T>
implements ShardedDao<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LookupDao.class);
    private List<LookupDaoPriv> daos;
    private final Class<T> entityClass;
    private final ShardCalculator<String> shardCalculator;
    private final ShardingBundleOptions shardingOptions;
    private final Field keyField;
    private final TransactionExecutor transactionExecutor;
    private final ShardInfoProvider shardInfoProvider;
    private final TransactionObserver observer;

    public LookupDao(List<SessionFactory> sessionFactories, Class<T> entityClass, ShardCalculator<String> shardCalculator, ShardingBundleOptions shardingOptions, ShardInfoProvider shardInfoProvider, TransactionObserver observer) {
        this.daos = sessionFactories.stream().map(x$0 -> new LookupDaoPriv((SessionFactory)x$0)).collect(Collectors.toList());
        this.entityClass = entityClass;
        this.shardCalculator = shardCalculator;
        this.shardingOptions = shardingOptions;
        this.shardInfoProvider = shardInfoProvider;
        this.observer = observer;
        this.transactionExecutor = new TransactionExecutor(shardInfoProvider, this.getClass(), entityClass, observer);
        Field[] fields = FieldUtils.getFieldsWithAnnotation(entityClass, LookupKey.class);
        Preconditions.checkArgument((fields.length != 0 ? 1 : 0) != 0, (Object)"At least one field needs to be sharding key");
        Preconditions.checkArgument((fields.length == 1 ? 1 : 0) != 0, (Object)"Only one field can be sharding key");
        this.keyField = fields[0];
        if (!this.keyField.isAccessible()) {
            try {
                this.keyField.setAccessible(true);
            }
            catch (SecurityException e) {
                log.error("Error making key field accessible please use a public method and mark that as LookupKey", (Throwable)e);
                throw new IllegalArgumentException("Invalid class, DAO cannot be created.", e);
            }
        }
        Preconditions.checkArgument((boolean)ClassUtils.isAssignable(this.keyField.getType(), String.class), (Object)"Key field must be a string");
    }

    public Optional<T> get(String key) throws Exception {
        return Optional.ofNullable(this.get(key, x -> x, t -> t));
    }

    public Optional<T> get(String key, UnaryOperator<Criteria> criteriaUpdater) throws Exception {
        return Optional.ofNullable(this.get(key, criteriaUpdater, t -> t));
    }

    public <U> U get(String key, Function<T, U> handler) throws Exception {
        int shardId = this.shardCalculator.shardId(key);
        LookupDaoPriv dao = this.daos.get(shardId);
        return this.transactionExecutor.execute(dao.sessionFactory, true, dao::get, key, handler, "get", shardId);
    }

    public <U> U get(String key, UnaryOperator<Criteria> criteriaUpdater, Function<T, U> handler) throws Exception {
        int shardId = this.shardCalculator.shardId(key);
        LookupDaoPriv dao = this.daos.get(shardId);
        return this.transactionExecutor.execute(dao.sessionFactory, true, k -> dao.get((String)k, criteriaUpdater), key, handler, "get", shardId);
    }

    public boolean exists(String key) throws Exception {
        return this.get(key).isPresent();
    }

    public Optional<T> save(T entity) throws Exception {
        return Optional.ofNullable(this.save(entity, t -> t));
    }

    public <U> U save(T entity, Function<T, U> handler) throws Exception {
        String key = this.keyField.get(entity).toString();
        int shardId = this.shardCalculator.shardId(key);
        log.debug("Saving entity of type {} with key {} to shard {}", new Object[]{this.entityClass.getSimpleName(), key, shardId});
        LookupDaoPriv dao = this.daos.get(shardId);
        return this.transactionExecutor.execute(dao.sessionFactory, false, dao::save, entity, handler, "save", shardId);
    }

    public Optional<T> createOrUpdate(String id, UnaryOperator<T> updater, Supplier<T> entityGenerator) {
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return Optional.of(this.transactionExecutor.execute(dao.sessionFactory, false, dao::getLockedForWrite, id, result -> {
            if (null == result) {
                Object newEntity = entityGenerator.get();
                if (null != newEntity) {
                    return dao.save(newEntity);
                }
                return null;
            }
            Object updated = updater.apply(result);
            if (null != updated) {
                dao.update(updated);
            }
            return dao.get(id);
        }, "createOrUpdate", shardId));
    }

    public boolean updateInLock(String id, Function<Optional<T>, T> updater) {
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return this.updateImpl(id, dao::getLockedForWrite, updater, shardId);
    }

    public boolean update(String id, Function<Optional<T>, T> updater) {
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return this.updateImpl(id, dao::get, updater, shardId);
    }

    public int updateUsingQuery(String id, UpdateOperationMeta updateOperationMeta) {
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return this.transactionExecutor.execute(dao.sessionFactory, false, dao::update, updateOperationMeta, "updateUsingQuery", shardId);
    }

    private boolean updateImpl(String id, Function<String, T> getter, Function<Optional<T>, T> updater, int shardId) {
        try {
            LookupDaoPriv dao = this.daos.get(shardId);
            return this.transactionExecutor.execute(dao.sessionFactory, true, getter, id, entity -> {
                Object newEntity = updater.apply(Optional.ofNullable(entity));
                if (null == newEntity) {
                    return false;
                }
                dao.update(newEntity);
                return true;
            }, "updateImpl", shardId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating entity: " + id, e);
        }
    }

    public LockedContext<T> lockAndGetExecutor(String id) {
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return new LockedContext<Object>(shardId, dao.sessionFactory, () -> dao.getLockedForWrite(id), this.entityClass, this.shardInfoProvider, this.observer);
    }

    public ReadOnlyContext<T> readOnlyExecutor(String id) {
        return this.readOnlyExecutor(id, x -> x);
    }

    public ReadOnlyContext<T> readOnlyExecutor(String id, UnaryOperator<Criteria> criteriaUpdater) {
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return new ReadOnlyContext<Object>(shardId, dao.sessionFactory, key -> dao.getLocked((String)key, criteriaUpdater, LockMode.NONE), null, id, this.shardingOptions.isSkipReadOnlyTransaction(), this.shardInfoProvider, this.entityClass, this.observer);
    }

    public ReadOnlyContext<T> readOnlyExecutor(String id, Supplier<Boolean> entityPopulator) {
        return this.readOnlyExecutor(id, x -> x, entityPopulator);
    }

    public ReadOnlyContext<T> readOnlyExecutor(String id, UnaryOperator<Criteria> criteriaUpdater, Supplier<Boolean> entityPopulator) {
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return new ReadOnlyContext<Object>(shardId, dao.sessionFactory, key -> dao.getLocked((String)key, criteriaUpdater, LockMode.NONE), entityPopulator, id, this.shardingOptions.isSkipReadOnlyTransaction(), this.shardInfoProvider, this.entityClass, this.observer);
    }

    public LockedContext<T> saveAndGetExecutor(T entity) {
        String id;
        try {
            id = this.keyField.get(entity).toString();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return new LockedContext<Object>(shardId, dao.sessionFactory, dao::save, entity, this.entityClass, this.shardInfoProvider, this.observer);
    }

    public List<T> scatterGather(DetachedCriteria criteria) {
        return IntStream.range(0, this.daos.size()).mapToObj(shardId -> {
            try {
                LookupDaoPriv dao = this.daos.get(shardId);
                return this.transactionExecutor.execute(dao.sessionFactory, true, dao::select, criteria, "scatterGather", shardId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public ScrollResult<T> scrollDown(DetachedCriteria inCriteria, ScrollPointer inPointer, int pageSize, @NonNull String sortFieldName) {
        if (sortFieldName == null) {
            throw new NullPointerException("sortFieldName is marked non-null but is null");
        }
        log.debug("SCROLL POINTER: {}", (Object)inPointer);
        ScrollPointer pointer = inPointer == null ? new ScrollPointer(ScrollPointer.Direction.DOWN) : inPointer;
        Preconditions.checkArgument((boolean)pointer.getDirection().equals((Object)ScrollPointer.Direction.DOWN), (Object)"A down scroll pointer needs to be passed to this method");
        return this.scrollImpl(inCriteria, pointer, pageSize, criteria -> criteria.addOrder(Order.asc((String)sortFieldName)), new FieldComparator<ScrollResultItem>(FieldUtils.getField(this.entityClass, (String)sortFieldName, (boolean)true)).thenComparing(ScrollResultItem::getShardIdx), "scrollDown");
    }

    public ScrollResult<T> scrollUp(DetachedCriteria inCriteria, ScrollPointer inPointer, int pageSize, @NonNull String sortFieldName) {
        if (sortFieldName == null) {
            throw new NullPointerException("sortFieldName is marked non-null but is null");
        }
        ScrollPointer pointer = null == inPointer ? new ScrollPointer(ScrollPointer.Direction.UP) : inPointer;
        Preconditions.checkArgument((boolean)pointer.getDirection().equals((Object)ScrollPointer.Direction.UP), (Object)"An up scroll pointer needs to be passed to this method");
        return this.scrollImpl(inCriteria, pointer, pageSize, criteria -> criteria.addOrder(Order.desc((String)sortFieldName)), new FieldComparator(FieldUtils.getField(this.entityClass, (String)sortFieldName, (boolean)true)).reversed().thenComparing(ScrollResultItem::getShardIdx), "scrollUp");
    }

    public List<Long> count(DetachedCriteria criteria) {
        return IntStream.range(0, this.daos.size()).mapToObj(shardId -> {
            LookupDaoPriv dao = this.daos.get(shardId);
            try {
                return this.transactionExecutor.execute(dao.sessionFactory, true, dao::count, criteria, "count", shardId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public Map<Integer, List> run(DetachedCriteria criteria) {
        return (Map)this.run(criteria, Function.identity());
    }

    public <U> U run(DetachedCriteria criteria, Function<Map<Integer, List>, U> translator) {
        Map output = IntStream.range(0, this.daos.size()).boxed().collect(Collectors.toMap(Function.identity(), shardId -> {
            LookupDaoPriv dao = this.daos.get((int)shardId);
            try {
                return this.transactionExecutor.execute(dao.sessionFactory, true, dao::run, criteria, "run", (int)shardId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        return translator.apply(output);
    }

    public List<T> get(List<String> keys) {
        Map lookupKeysGroupByShards = keys.stream().collect(Collectors.groupingBy(this.shardCalculator::shardId, Collectors.toList()));
        return lookupKeysGroupByShards.keySet().stream().map(shardId -> {
            try {
                DetachedCriteria criteria = DetachedCriteria.forClass(this.entityClass).add(Restrictions.in((String)this.keyField.getName(), (Collection)((Collection)lookupKeysGroupByShards.get(shardId))));
                return this.transactionExecutor.execute(this.daos.get((int)shardId).sessionFactory, true, this.daos.get((int)shardId)::select, criteria, "get", (int)shardId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public <U> U runInSession(String id, Function<Session, U> handler) {
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return this.transactionExecutor.execute(dao.sessionFactory, true, handler, true, "runInSession", shardId);
    }

    public <U, V> V runInSession(BiFunction<Integer, Session, U> sessionHandler, Function<Map<Integer, U>, V> translator) {
        Map output = IntStream.range(0, this.daos.size()).boxed().collect(Collectors.toMap(Function.identity(), shardId -> {
            LookupDaoPriv dao = this.daos.get((int)shardId);
            try {
                return this.transactionExecutor.execute(dao.sessionFactory, true, currSession -> sessionHandler.apply((Integer)shardId, (Session)currSession), true, "runInSession", (int)shardId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        return translator.apply(output);
    }

    public boolean delete(String id) {
        int shardId = this.shardCalculator.shardId(id);
        return this.transactionExecutor.execute(this.daos.get(shardId).sessionFactory, false, this.daos.get(shardId)::delete, id, "delete", shardId);
    }

    protected Field getKeyField() {
        return this.keyField;
    }

    private ScrollResult<T> scrollImpl(DetachedCriteria inCriteria, ScrollPointer pointer, int pageSize, UnaryOperator<DetachedCriteria> criteriaMutator, Comparator<ScrollResultItem<T>> comparator, String methodName) {
        AtomicInteger daoIndex = new AtomicInteger();
        List<ScrollResultItem> results = this.daos.stream().flatMap(dao -> {
            int currIdx = daoIndex.getAndIncrement();
            DetachedCriteria criteria = (DetachedCriteria)criteriaMutator.apply(InternalUtils.cloneObject(inCriteria));
            return this.transactionExecutor.execute(((LookupDaoPriv)dao).sessionFactory, true, queryCriteria -> dao.select((DetachedCriteria)queryCriteria, pointer.getCurrOffset(currIdx), pageSize), criteria, methodName, currIdx).stream().map(item -> new ScrollResultItem<Object>(item, currIdx));
        }).sorted(comparator).limit(pageSize).collect(Collectors.toList());
        ImmutableList.Builder outputBuilder = ImmutableList.builder();
        results.forEach(result -> {
            outputBuilder.add(result.getData());
            pointer.advance(result.getShardIdx(), 1);
        });
        return new ScrollResult(pointer, outputBuilder.build());
    }

    @Override
    @Generated
    public ShardCalculator<String> getShardCalculator() {
        return this.shardCalculator;
    }

    @Generated
    public ShardingBundleOptions getShardingOptions() {
        return this.shardingOptions;
    }

    public static class ReadOnlyContext<T> {
        private final int shardId;
        private final SessionFactory sessionFactory;
        private final Function<String, T> getter;
        private final Supplier<Boolean> entityPopulator;
        private final String key;
        private final List<Function<T, Void>> operations = Lists.newArrayList();
        private final boolean skipTransaction;
        private final TransactionExecutionContext executionContext;
        private final TransactionObserver observer;

        public ReadOnlyContext(int shardId, SessionFactory sessionFactory, Function<String, T> getter, Supplier<Boolean> entityPopulator, String key, boolean skipTxn, ShardInfoProvider shardInfoProvider, Class<?> entityClass, TransactionObserver observer) {
            this.shardId = shardId;
            this.sessionFactory = sessionFactory;
            this.getter = getter;
            this.entityPopulator = entityPopulator;
            this.key = key;
            this.skipTransaction = skipTxn;
            this.observer = observer;
            String shardName = shardInfoProvider.shardName(shardId);
            this.executionContext = TransactionExecutionContext.builder().opType("execute").shardName(shardName).daoClass(this.getClass()).entityClass(entityClass).build();
        }

        public ReadOnlyContext<T> apply(Function<T, Void> handler) {
            this.operations.add(handler);
            return this;
        }

        public <U> ReadOnlyContext<T> readOneAugmentParent(RelationalDao<U> relationalDao, DetachedCriteria criteria, BiConsumer<T, List<U>> consumer) {
            return this.readAugmentParent(relationalDao, criteria, 0, 1, consumer, p -> true);
        }

        public <U> ReadOnlyContext<T> readAugmentParent(RelationalDao<U> relationalDao, DetachedCriteria criteria, int first, int numResults, BiConsumer<T, List<U>> consumer) {
            return this.readAugmentParent(relationalDao, criteria, first, numResults, consumer, p -> true);
        }

        public <U> ReadOnlyContext<T> readOneAugmentParent(RelationalDao<U> relationalDao, DetachedCriteria criteria, BiConsumer<T, List<U>> consumer, Predicate<T> filter) {
            return this.readAugmentParent(relationalDao, criteria, 0, 1, consumer, filter);
        }

        public <U> ReadOnlyContext<T> readAugmentParent(RelationalDao<U> relationalDao, DetachedCriteria criteria, int first, int numResults, BiConsumer<T, List<U>> consumer, Predicate<T> filter) {
            return this.apply(parent -> {
                if (filter.test(parent)) {
                    try {
                        consumer.accept(parent, relationalDao.select(this, criteria, first, numResults));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            });
        }

        public Optional<T> execute() {
            T result = this.executeImpl();
            if (null == result && null != this.entityPopulator && Boolean.TRUE.equals(this.entityPopulator.get())) {
                result = this.executeImpl();
            }
            return Optional.ofNullable(result);
        }

        private T executeImpl() {
            return (T)this.observer.execute(this.executionContext, () -> {
                TransactionHandler transactionHandler = new TransactionHandler(this.sessionFactory, true, this.skipTransaction);
                transactionHandler.beforeStart();
                try {
                    Object result = this.getter.apply(this.key);
                    if (null != result) {
                        this.operations.forEach(operation -> {
                            Void cfr_ignored_0 = (Void)operation.apply(result);
                        });
                    }
                    Object t = result;
                    return t;
                }
                catch (Exception e) {
                    transactionHandler.onError();
                    throw e;
                }
                finally {
                    transactionHandler.afterEnd();
                }
            });
        }

        @Generated
        public int getShardId() {
            return this.shardId;
        }

        @Generated
        public SessionFactory getSessionFactory() {
            return this.sessionFactory;
        }

        @Generated
        public Function<String, T> getGetter() {
            return this.getter;
        }

        @Generated
        public Supplier<Boolean> getEntityPopulator() {
            return this.entityPopulator;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public List<Function<T, Void>> getOperations() {
            return this.operations;
        }

        @Generated
        public boolean isSkipTransaction() {
            return this.skipTransaction;
        }

        @Generated
        public TransactionExecutionContext getExecutionContext() {
            return this.executionContext;
        }

        @Generated
        public TransactionObserver getObserver() {
            return this.observer;
        }
    }

    private final class LookupDaoPriv
    extends AbstractDAO<T> {
        private final SessionFactory sessionFactory;

        public LookupDaoPriv(SessionFactory sessionFactory) {
            super(sessionFactory);
            this.sessionFactory = sessionFactory;
        }

        T get(String lookupKey) {
            return this.getLocked(lookupKey, x -> x, LockMode.READ);
        }

        T get(String lookupKey, UnaryOperator<Criteria> criteriaUpdater) {
            return this.getLocked(lookupKey, criteriaUpdater, LockMode.READ);
        }

        T getLockedForWrite(String lookupKey) {
            return this.getLockedForWrite(lookupKey, x -> x);
        }

        T getLockedForWrite(String lookupKey, UnaryOperator<Criteria> criteriaUpdater) {
            return this.getLocked(lookupKey, criteriaUpdater, LockMode.UPGRADE_NOWAIT);
        }

        T getLocked(String lookupKey, UnaryOperator<Criteria> criteriaUpdater, LockMode lockMode) {
            Criteria criteria = (Criteria)criteriaUpdater.apply(this.currentSession().createCriteria(LookupDao.this.entityClass).add((Criterion)Restrictions.eq((String)LookupDao.this.keyField.getName(), (Object)lookupKey)).setLockMode(lockMode));
            return this.uniqueResult(criteria);
        }

        T save(T entity) {
            return this.persist(entity);
        }

        void update(T entity) {
            this.currentSession().evict(entity);
            this.currentSession().update(entity);
        }

        List<T> select(DetachedCriteria criteria) {
            return this.list(criteria.getExecutableCriteria(this.currentSession()));
        }

        List run(DetachedCriteria criteria) {
            return criteria.getExecutableCriteria(this.currentSession()).list();
        }

        List<T> select(DetachedCriteria criteria, int start, int count) {
            Criteria executableCriteria = criteria.getExecutableCriteria(this.currentSession());
            if (-1 != start) {
                executableCriteria.setFirstResult(start);
            }
            if (-1 != count) {
                executableCriteria.setMaxResults(count);
            }
            return this.list(executableCriteria);
        }

        long count(DetachedCriteria criteria) {
            return (Long)criteria.getExecutableCriteria(this.currentSession()).setProjection(Projections.rowCount()).uniqueResult();
        }

        boolean delete(String id) {
            return Optional.ofNullable(this.getLocked(id, x -> x, LockMode.UPGRADE_NOWAIT)).map(object -> {
                this.currentSession().delete(object);
                return true;
            }).orElse(false);
        }

        public int update(UpdateOperationMeta updateOperationMeta) {
            Query query = this.currentSession().createNamedQuery(updateOperationMeta.getQueryName());
            updateOperationMeta.getParams().forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
            return query.executeUpdate();
        }
    }
}

