/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.dao;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.appform.dropwizard.sharding.ShardInfoProvider;
import io.appform.dropwizard.sharding.config.ShardingBundleOptions;
import io.appform.dropwizard.sharding.dao.LockedContext;
import io.appform.dropwizard.sharding.dao.RelationalDao;
import io.appform.dropwizard.sharding.dao.ShardedDao;
import io.appform.dropwizard.sharding.dao.UpdateOperationMeta;
import io.appform.dropwizard.sharding.execution.TransactionExecutionContext;
import io.appform.dropwizard.sharding.execution.TransactionExecutor;
import io.appform.dropwizard.sharding.observers.TransactionObserver;
import io.appform.dropwizard.sharding.sharding.LookupKey;
import io.appform.dropwizard.sharding.utils.ShardCalculator;
import io.appform.dropwizard.sharding.utils.TransactionHandler;
import io.dropwizard.hibernate.AbstractDAO;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupDao<T>
implements ShardedDao<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LookupDao.class);
    private List<LookupDaoPriv> daos;
    private final Class<T> entityClass;
    private final ShardCalculator<String> shardCalculator;
    private final ShardingBundleOptions shardingOptions;
    private final Field keyField;
    private final TransactionExecutor transactionExecutor;
    private final ShardInfoProvider shardInfoProvider;
    private final TransactionObserver observer;

    public LookupDao(List<SessionFactory> sessionFactories, Class<T> entityClass, ShardCalculator<String> shardCalculator, ShardingBundleOptions shardingOptions, ShardInfoProvider shardInfoProvider, TransactionObserver observer) {
        this.daos = sessionFactories.stream().map(x$0 -> new LookupDaoPriv((SessionFactory)x$0)).collect(Collectors.toList());
        this.entityClass = entityClass;
        this.shardCalculator = shardCalculator;
        this.shardingOptions = shardingOptions;
        this.shardInfoProvider = shardInfoProvider;
        this.observer = observer;
        this.transactionExecutor = new TransactionExecutor(shardInfoProvider, this.getClass(), entityClass, observer);
        Field[] fields = FieldUtils.getFieldsWithAnnotation(entityClass, LookupKey.class);
        Preconditions.checkArgument((fields.length != 0 ? 1 : 0) != 0, (Object)"At least one field needs to be sharding key");
        Preconditions.checkArgument((fields.length == 1 ? 1 : 0) != 0, (Object)"Only one field can be sharding key");
        this.keyField = fields[0];
        if (!this.keyField.isAccessible()) {
            try {
                this.keyField.setAccessible(true);
            }
            catch (SecurityException e) {
                log.error("Error making key field accessible please use a public method and mark that as LookupKey", (Throwable)e);
                throw new IllegalArgumentException("Invalid class, DAO cannot be created.", e);
            }
        }
        Preconditions.checkArgument((boolean)ClassUtils.isAssignable(this.keyField.getType(), String.class), (Object)"Key field must be a string");
    }

    public Optional<T> get(String key) throws Exception {
        return Optional.ofNullable(this.get(key, t -> t));
    }

    public <U> U get(String key, Function<T, U> handler) throws Exception {
        int shardId = this.shardCalculator.shardId(key);
        LookupDaoPriv dao = this.daos.get(shardId);
        return this.transactionExecutor.execute(dao.sessionFactory, true, dao::get, key, handler, "get", shardId);
    }

    public boolean exists(String key) throws Exception {
        return this.get(key).isPresent();
    }

    public Optional<T> save(T entity) throws Exception {
        return Optional.ofNullable(this.save(entity, t -> t));
    }

    public <U> U save(T entity, Function<T, U> handler) throws Exception {
        String key = this.keyField.get(entity).toString();
        int shardId = this.shardCalculator.shardId(key);
        log.debug("Saving entity of type {} with key {} to shard {}", new Object[]{this.entityClass.getSimpleName(), key, shardId});
        LookupDaoPriv dao = this.daos.get(shardId);
        return this.transactionExecutor.execute(dao.sessionFactory, false, dao::save, entity, handler, "save", shardId);
    }

    public boolean updateInLock(String id, Function<Optional<T>, T> updater) {
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return this.updateImpl(id, dao::getLockedForWrite, updater, shardId);
    }

    public boolean update(String id, Function<Optional<T>, T> updater) {
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return this.updateImpl(id, dao::get, updater, shardId);
    }

    public int updateUsingQuery(String id, UpdateOperationMeta updateOperationMeta) {
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return this.transactionExecutor.execute(dao.sessionFactory, false, dao::update, updateOperationMeta, "updateUsingQuery", shardId);
    }

    private boolean updateImpl(String id, Function<String, T> getter, Function<Optional<T>, T> updater, int shardId) {
        try {
            LookupDaoPriv dao = this.daos.get(shardId);
            return this.transactionExecutor.execute(dao.sessionFactory, true, getter, id, entity -> {
                Object newEntity = updater.apply(Optional.ofNullable(entity));
                if (null == newEntity) {
                    return false;
                }
                dao.update(newEntity);
                return true;
            }, "updateImpl", shardId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating entity: " + id, e);
        }
    }

    public LockedContext<T> lockAndGetExecutor(String id) {
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return new LockedContext<Object>(shardId, dao.sessionFactory, () -> dao.getLockedForWrite(id), this.entityClass, this.shardInfoProvider, this.observer);
    }

    public ReadOnlyContext<T> readOnlyExecutor(String id) {
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return new ReadOnlyContext<Object>(shardId, dao.sessionFactory, key -> dao.getLocked((String)key, LockMode.NONE), null, id, this.shardingOptions.isSkipReadOnlyTransaction(), this.shardInfoProvider, this.entityClass, this.observer);
    }

    public ReadOnlyContext<T> readOnlyExecutor(String id, Supplier<Boolean> entityPopulator) {
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return new ReadOnlyContext<Object>(shardId, dao.sessionFactory, key -> dao.getLocked((String)key, LockMode.NONE), entityPopulator, id, this.shardingOptions.isSkipReadOnlyTransaction(), this.shardInfoProvider, this.entityClass, this.observer);
    }

    public LockedContext<T> saveAndGetExecutor(T entity) {
        String id;
        try {
            id = this.keyField.get(entity).toString();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return new LockedContext<Object>(shardId, dao.sessionFactory, dao::save, entity, this.entityClass, this.shardInfoProvider, this.observer);
    }

    public List<T> scatterGather(DetachedCriteria criteria) {
        return IntStream.range(0, this.daos.size()).mapToObj(shardId -> {
            try {
                LookupDaoPriv dao = this.daos.get(shardId);
                return this.transactionExecutor.execute(dao.sessionFactory, true, dao::select, criteria, "scatterGather", shardId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Long> count(DetachedCriteria criteria) {
        return IntStream.range(0, this.daos.size()).mapToObj(shardId -> {
            LookupDaoPriv dao = this.daos.get(shardId);
            try {
                return this.transactionExecutor.execute(dao.sessionFactory, true, dao::count, criteria, "count", shardId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public List<T> get(List<String> keys) {
        Map lookupKeysGroupByShards = keys.stream().collect(Collectors.groupingBy(this.shardCalculator::shardId, Collectors.toList()));
        return lookupKeysGroupByShards.keySet().stream().map(shardId -> {
            try {
                DetachedCriteria criteria = DetachedCriteria.forClass(this.entityClass).add(Restrictions.in((String)this.keyField.getName(), (Collection)((Collection)lookupKeysGroupByShards.get(shardId))));
                return this.transactionExecutor.execute(this.daos.get((int)shardId).sessionFactory, true, this.daos.get((int)shardId)::select, criteria, "get", (int)shardId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public <U> U runInSession(String id, Function<Session, U> handler) {
        int shardId = this.shardCalculator.shardId(id);
        LookupDaoPriv dao = this.daos.get(shardId);
        return this.transactionExecutor.execute(dao.sessionFactory, true, handler, true, "runInSession", shardId);
    }

    public boolean delete(String id) {
        int shardId = this.shardCalculator.shardId(id);
        return this.transactionExecutor.execute(this.daos.get(shardId).sessionFactory, false, this.daos.get(shardId)::delete, id, "delete", shardId);
    }

    protected Field getKeyField() {
        return this.keyField;
    }

    @Override
    @Generated
    public ShardCalculator<String> getShardCalculator() {
        return this.shardCalculator;
    }

    @Generated
    public ShardingBundleOptions getShardingOptions() {
        return this.shardingOptions;
    }

    public static class ReadOnlyContext<T> {
        private final int shardId;
        private final SessionFactory sessionFactory;
        private final Function<String, T> getter;
        private final Supplier<Boolean> entityPopulator;
        private final String key;
        private final List<Function<T, Void>> operations = Lists.newArrayList();
        private final boolean skipTransaction;
        private final TransactionExecutionContext executionContext;
        private final TransactionObserver observer;

        public ReadOnlyContext(int shardId, SessionFactory sessionFactory, Function<String, T> getter, Supplier<Boolean> entityPopulator, String key, boolean skipTxn, ShardInfoProvider shardInfoProvider, Class<?> entityClass, TransactionObserver observer) {
            this.shardId = shardId;
            this.sessionFactory = sessionFactory;
            this.getter = getter;
            this.entityPopulator = entityPopulator;
            this.key = key;
            this.skipTransaction = skipTxn;
            this.observer = observer;
            String shardName = shardInfoProvider.shardName(shardId);
            this.executionContext = TransactionExecutionContext.builder().opType("execute").shardName(shardName).daoClass(this.getClass()).entityClass(entityClass).build();
        }

        public ReadOnlyContext<T> apply(Function<T, Void> handler) {
            this.operations.add(handler);
            return this;
        }

        public <U> ReadOnlyContext<T> readOneAugmentParent(RelationalDao<U> relationalDao, DetachedCriteria criteria, BiConsumer<T, List<U>> consumer) {
            return this.readAugmentParent(relationalDao, criteria, 0, 1, consumer, p -> true);
        }

        public <U> ReadOnlyContext<T> readAugmentParent(RelationalDao<U> relationalDao, DetachedCriteria criteria, int first, int numResults, BiConsumer<T, List<U>> consumer) {
            return this.readAugmentParent(relationalDao, criteria, first, numResults, consumer, p -> true);
        }

        public <U> ReadOnlyContext<T> readOneAugmentParent(RelationalDao<U> relationalDao, DetachedCriteria criteria, BiConsumer<T, List<U>> consumer, Predicate<T> filter) {
            return this.readAugmentParent(relationalDao, criteria, 0, 1, consumer, filter);
        }

        public <U> ReadOnlyContext<T> readAugmentParent(RelationalDao<U> relationalDao, DetachedCriteria criteria, int first, int numResults, BiConsumer<T, List<U>> consumer, Predicate<T> filter) {
            return this.apply(parent -> {
                if (filter.test(parent)) {
                    try {
                        consumer.accept(parent, relationalDao.select(this, criteria, first, numResults));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            });
        }

        public Optional<T> execute() {
            T result = this.executeImpl();
            if (null == result && null != this.entityPopulator && Boolean.TRUE.equals(this.entityPopulator.get())) {
                result = this.executeImpl();
            }
            return Optional.ofNullable(result);
        }

        private T executeImpl() {
            return (T)this.observer.execute(this.executionContext, () -> {
                TransactionHandler transactionHandler = new TransactionHandler(this.sessionFactory, true, this.skipTransaction);
                transactionHandler.beforeStart();
                try {
                    Object result = this.getter.apply(this.key);
                    if (null != result) {
                        this.operations.forEach(operation -> {
                            Void cfr_ignored_0 = (Void)operation.apply(result);
                        });
                    }
                    Object t = result;
                    return t;
                }
                catch (Exception e) {
                    transactionHandler.onError();
                    throw e;
                }
                finally {
                    transactionHandler.afterEnd();
                }
            });
        }

        @Generated
        public int getShardId() {
            return this.shardId;
        }

        @Generated
        public SessionFactory getSessionFactory() {
            return this.sessionFactory;
        }

        @Generated
        public Function<String, T> getGetter() {
            return this.getter;
        }

        @Generated
        public Supplier<Boolean> getEntityPopulator() {
            return this.entityPopulator;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public List<Function<T, Void>> getOperations() {
            return this.operations;
        }

        @Generated
        public boolean isSkipTransaction() {
            return this.skipTransaction;
        }

        @Generated
        public TransactionExecutionContext getExecutionContext() {
            return this.executionContext;
        }

        @Generated
        public TransactionObserver getObserver() {
            return this.observer;
        }
    }

    private final class LookupDaoPriv
    extends AbstractDAO<T> {
        private final SessionFactory sessionFactory;

        public LookupDaoPriv(SessionFactory sessionFactory) {
            super(sessionFactory);
            this.sessionFactory = sessionFactory;
        }

        T get(String lookupKey) {
            return this.getLocked(lookupKey, LockMode.READ);
        }

        T getLockedForWrite(String lookupKey) {
            return this.getLocked(lookupKey, LockMode.UPGRADE_NOWAIT);
        }

        T getLocked(String lookupKey, LockMode lockMode) {
            return this.uniqueResult(this.currentSession().createCriteria(LookupDao.this.entityClass).add((Criterion)Restrictions.eq((String)LookupDao.this.keyField.getName(), (Object)lookupKey)).setLockMode(lockMode));
        }

        T save(T entity) {
            return this.persist(entity);
        }

        void update(T entity) {
            this.currentSession().evict(entity);
            this.currentSession().update(entity);
        }

        List<T> select(DetachedCriteria criteria) {
            return this.list(criteria.getExecutableCriteria(this.currentSession()));
        }

        long count(DetachedCriteria criteria) {
            return (Long)criteria.getExecutableCriteria(this.currentSession()).setProjection(Projections.rowCount()).uniqueResult();
        }

        boolean delete(String id) {
            return Optional.ofNullable(this.getLocked(id, LockMode.UPGRADE_NOWAIT)).map(object -> {
                this.currentSession().delete(object);
                return true;
            }).orElse(false);
        }

        public int update(UpdateOperationMeta updateOperationMeta) {
            Query query = this.currentSession().createNamedQuery(updateOperationMeta.getQueryName());
            updateOperationMeta.getParams().forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
            return query.executeUpdate();
        }
    }
}

