/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardInfoProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardInfoProvider.class);
    private final String namespace;
    private static final String SHARD_NAMING_FORMAT = "connectionpool-%s-%d";
    private static final String SHARD_NAMING_REGEX = "connectionpool-(\\w+)-(\\d+)";
    private static final Pattern SHARD_NAMING_PATTERN = Pattern.compile("connectionpool-(\\w+)-(\\d+)");

    public ShardInfoProvider(String namespace) {
        this.namespace = namespace;
    }

    public int shardId(String name) {
        Matcher matcher = SHARD_NAMING_PATTERN.matcher(name);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(2));
        }
        return -1;
    }

    public String namespace(String name) {
        Matcher matcher = SHARD_NAMING_PATTERN.matcher(name);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public String shardName(int shardId) {
        return String.format(SHARD_NAMING_FORMAT, this.namespace, shardId);
    }

    @Generated
    public static ShardInfoProviderBuilder builder() {
        return new ShardInfoProviderBuilder();
    }

    @Generated
    public static class ShardInfoProviderBuilder {
        @Generated
        private String namespace;

        @Generated
        ShardInfoProviderBuilder() {
        }

        @Generated
        public ShardInfoProviderBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public ShardInfoProvider build() {
            return new ShardInfoProvider(this.namespace);
        }

        @Generated
        public String toString() {
            return "ShardInfoProvider.ShardInfoProviderBuilder(namespace=" + this.namespace + ")";
        }
    }
}

