/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding;

import com.codahale.metrics.health.HealthCheckRegistryListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.appform.dropwizard.sharding.ShardInfoProvider;
import io.appform.dropwizard.sharding.admin.BlacklistShardTask;
import io.appform.dropwizard.sharding.admin.UnblacklistShardTask;
import io.appform.dropwizard.sharding.caching.LookupCache;
import io.appform.dropwizard.sharding.caching.RelationalCache;
import io.appform.dropwizard.sharding.config.ShardedHibernateFactory;
import io.appform.dropwizard.sharding.config.ShardingBundleOptions;
import io.appform.dropwizard.sharding.dao.CacheableLookupDao;
import io.appform.dropwizard.sharding.dao.CacheableRelationalDao;
import io.appform.dropwizard.sharding.dao.LookupDao;
import io.appform.dropwizard.sharding.dao.RelationalDao;
import io.appform.dropwizard.sharding.dao.WrapperDao;
import io.appform.dropwizard.sharding.filters.TransactionFilter;
import io.appform.dropwizard.sharding.healthcheck.HealthCheckManager;
import io.appform.dropwizard.sharding.listeners.TransactionListener;
import io.appform.dropwizard.sharding.observers.TransactionObserver;
import io.appform.dropwizard.sharding.observers.internal.FilteringObserver;
import io.appform.dropwizard.sharding.observers.internal.ListenerTriggeringObserver;
import io.appform.dropwizard.sharding.observers.internal.TerminalTransactionObserver;
import io.appform.dropwizard.sharding.sharding.BucketIdExtractor;
import io.appform.dropwizard.sharding.sharding.InMemoryLocalShardBlacklistingStore;
import io.appform.dropwizard.sharding.sharding.ShardBlacklistingStore;
import io.appform.dropwizard.sharding.sharding.ShardManager;
import io.appform.dropwizard.sharding.sharding.impl.ConsistentHashBucketIdExtractor;
import io.appform.dropwizard.sharding.utils.ShardCalculator;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.hibernate.AbstractDAO;
import io.dropwizard.hibernate.HibernateBundle;
import io.dropwizard.hibernate.SessionFactoryFactory;
import io.dropwizard.servlets.tasks.Task;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.persistence.Entity;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBShardingBundleBase<T extends Configuration>
implements ConfiguredBundle<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DBShardingBundleBase.class);
    private static final String DEFAULT_NAMESPACE = "default";
    private static final String SHARD_ENV = "db.shards";
    private static final String DEFAULT_SHARDS = "2";
    private List<HibernateBundle<T>> shardBundles = Lists.newArrayList();
    private List<SessionFactory> sessionFactories;
    private ShardManager shardManager;
    private String dbNamespace;
    private int numShards;
    private ShardingBundleOptions shardingOptions;
    private ShardInfoProvider shardInfoProvider;
    private HealthCheckManager healthCheckManager;
    private final List<TransactionListener> listeners = new ArrayList<TransactionListener>();
    private final List<TransactionFilter> filters = new ArrayList<TransactionFilter>();
    private final List<TransactionObserver> observers = new ArrayList<TransactionObserver>();
    private TransactionObserver rootObserver;

    protected DBShardingBundleBase(String dbNamespace, Class<?> entity, Class<?> ... entities) {
        this.dbNamespace = dbNamespace;
        ImmutableList inEntities = ImmutableList.builder().add(entity).add((Object[])entities).build();
        this.init(inEntities);
    }

    protected DBShardingBundleBase(String dbNamespace, List<String> classPathPrefixList) {
        this.dbNamespace = dbNamespace;
        Set entities = new Reflections(new Object[]{classPathPrefixList}).getTypesAnnotatedWith(Entity.class);
        Preconditions.checkArgument((!entities.isEmpty() ? 1 : 0) != 0, (Object)String.format("No entity class found at %s", String.join((CharSequence)",", classPathPrefixList)));
        ImmutableList inEntities = ImmutableList.builder().addAll((Iterable)entities).build();
        this.init(inEntities);
    }

    protected DBShardingBundleBase(Class<?> entity, Class<?> ... entities) {
        this(DEFAULT_NAMESPACE, entity, entities);
    }

    protected DBShardingBundleBase(String ... classPathPrefixes) {
        this(DEFAULT_NAMESPACE, Arrays.asList(classPathPrefixes));
    }

    protected abstract ShardManager createShardManager(int var1, ShardBlacklistingStore var2);

    private void init(ImmutableList<Class<?>> inEntities) {
        boolean defaultNamespace = StringUtils.equalsIgnoreCase((CharSequence)this.dbNamespace, (CharSequence)DEFAULT_NAMESPACE);
        String numShardsProperty = defaultNamespace ? SHARD_ENV : String.join((CharSequence)".", this.dbNamespace, SHARD_ENV);
        String numShardsEnv = System.getProperty(numShardsProperty, DEFAULT_SHARDS);
        this.numShards = Integer.parseInt(numShardsEnv);
        ShardBlacklistingStore blacklistingStore = this.getBlacklistingStore();
        this.shardManager = this.createShardManager(this.numShards, blacklistingStore);
        this.shardInfoProvider = new ShardInfoProvider(this.dbNamespace);
        this.healthCheckManager = new HealthCheckManager(this.dbNamespace, this.shardInfoProvider, blacklistingStore, this.shardManager);
        IntStream.range(0, this.numShards).forEach(shard -> this.shardBundles.add(new HibernateBundle<T>((List)inEntities, new SessionFactoryFactory()){

            protected String name() {
                return DBShardingBundleBase.this.shardInfoProvider.shardName(shard);
            }

            public PooledDataSourceFactory getDataSourceFactory(T t) {
                return (PooledDataSourceFactory)DBShardingBundleBase.this.getConfig(t).getShards().get(shard);
            }
        }));
    }

    public void run(T configuration, Environment environment) {
        int shardConfigurationListSize = this.getConfig(configuration).getShards().size();
        if (this.numShards != shardConfigurationListSize) {
            throw new RuntimeException("Shard count provided through environment does not match the size of the shard configuration list");
        }
        this.sessionFactories = this.shardBundles.stream().map(HibernateBundle::getSessionFactory).collect(Collectors.toList());
        this.shardingOptions = this.getShardingOptions(configuration);
        environment.admin().addTask((Task)new BlacklistShardTask(this.shardManager));
        environment.admin().addTask((Task)new UnblacklistShardTask(this.shardManager));
        this.healthCheckManager.manageHealthChecks(this.getConfig(configuration).getBlacklist(), environment);
        this.setupObservers();
    }

    public final void registerObserver(TransactionObserver observer) {
        if (null == observer) {
            return;
        }
        this.observers.add(observer);
        log.info("Registered observer: " + observer.getClass().getSimpleName());
    }

    public final void registerListener(TransactionListener listener) {
        if (null == listener) {
            return;
        }
        this.listeners.add(listener);
        log.info("Registered listener: " + listener.getClass().getSimpleName());
    }

    public final void registerFilter(TransactionFilter filter) {
        if (null == filter) {
            return;
        }
        this.filters.add(filter);
        log.info("Registered filter: " + filter.getClass().getSimpleName());
    }

    public void initialize(Bootstrap<?> bootstrap) {
        bootstrap.getHealthCheckRegistry().addListener((HealthCheckRegistryListener)this.healthCheckManager);
        this.shardBundles.forEach(hibernateBundle -> bootstrap.addBundle((ConfiguredBundle)hibernateBundle));
    }

    @VisibleForTesting
    public void runBundles(T configuration, Environment environment) {
        this.shardBundles.forEach(hibernateBundle -> {
            try {
                hibernateBundle.run(configuration, environment);
            }
            catch (Exception e) {
                log.error("Error initializing db sharding bundle", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    @VisibleForTesting
    public void initBundles(Bootstrap bootstrap) {
        this.shardBundles.forEach(hibernameBundle -> this.initialize(bootstrap));
    }

    @VisibleForTesting
    public Map<Integer, Boolean> healthStatus() {
        return this.healthCheckManager.status();
    }

    protected abstract ShardedHibernateFactory getConfig(T var1);

    protected ShardBlacklistingStore getBlacklistingStore() {
        return new InMemoryLocalShardBlacklistingStore();
    }

    private ShardingBundleOptions getShardingOptions(T configuration) {
        ShardingBundleOptions shardingOptions = this.getConfig(configuration).getShardingOptions();
        return Objects.nonNull(shardingOptions) ? shardingOptions : new ShardingBundleOptions();
    }

    public <EntityType, T extends Configuration> LookupDao<EntityType> createParentObjectDao(Class<EntityType> clazz) {
        return new LookupDao<EntityType>(this.sessionFactories, clazz, new ShardCalculator<String>(this.shardManager, new ConsistentHashBucketIdExtractor(this.shardManager)), this.shardingOptions, this.shardInfoProvider, this.rootObserver);
    }

    public <EntityType, T extends Configuration> CacheableLookupDao<EntityType> createParentObjectDao(Class<EntityType> clazz, LookupCache<EntityType> cacheManager) {
        return new CacheableLookupDao<EntityType>(this.sessionFactories, clazz, new ShardCalculator<String>(this.shardManager, new ConsistentHashBucketIdExtractor(this.shardManager)), cacheManager, this.shardingOptions, this.shardInfoProvider, this.rootObserver);
    }

    public <EntityType, T extends Configuration> LookupDao<EntityType> createParentObjectDao(Class<EntityType> clazz, BucketIdExtractor<String> bucketIdExtractor) {
        return new LookupDao<EntityType>(this.sessionFactories, clazz, new ShardCalculator<String>(this.shardManager, bucketIdExtractor), this.shardingOptions, this.shardInfoProvider, this.rootObserver);
    }

    public <EntityType, T extends Configuration> CacheableLookupDao<EntityType> createParentObjectDao(Class<EntityType> clazz, BucketIdExtractor<String> bucketIdExtractor, LookupCache<EntityType> cacheManager) {
        return new CacheableLookupDao<EntityType>(this.sessionFactories, clazz, new ShardCalculator<String>(this.shardManager, bucketIdExtractor), cacheManager, this.shardingOptions, this.shardInfoProvider, this.rootObserver);
    }

    public <EntityType, T extends Configuration> RelationalDao<EntityType> createRelatedObjectDao(Class<EntityType> clazz) {
        return new RelationalDao<EntityType>(this.sessionFactories, clazz, new ShardCalculator<String>(this.shardManager, new ConsistentHashBucketIdExtractor(this.shardManager)), this.shardInfoProvider, this.rootObserver);
    }

    public <EntityType, T extends Configuration> CacheableRelationalDao<EntityType> createRelatedObjectDao(Class<EntityType> clazz, RelationalCache<EntityType> cacheManager) {
        return new CacheableRelationalDao<EntityType>(this.sessionFactories, clazz, new ShardCalculator<String>(this.shardManager, new ConsistentHashBucketIdExtractor(this.shardManager)), cacheManager, this.shardInfoProvider, this.rootObserver);
    }

    public <EntityType, T extends Configuration> RelationalDao<EntityType> createRelatedObjectDao(Class<EntityType> clazz, BucketIdExtractor<String> bucketIdExtractor) {
        return new RelationalDao<EntityType>(this.sessionFactories, clazz, new ShardCalculator<String>(this.shardManager, bucketIdExtractor), this.shardInfoProvider, this.rootObserver);
    }

    public <EntityType, T extends Configuration> CacheableRelationalDao<EntityType> createRelatedObjectDao(Class<EntityType> clazz, BucketIdExtractor<String> bucketIdExtractor, RelationalCache<EntityType> cacheManager) {
        return new CacheableRelationalDao<EntityType>(this.sessionFactories, clazz, new ShardCalculator<String>(this.shardManager, bucketIdExtractor), cacheManager, this.shardInfoProvider, this.rootObserver);
    }

    public <EntityType, DaoType extends AbstractDAO<EntityType>, T extends Configuration> WrapperDao<EntityType, DaoType> createWrapperDao(Class<DaoType> daoTypeClass) {
        return new WrapperDao(this.sessionFactories, daoTypeClass, new ShardCalculator<String>(this.shardManager, new ConsistentHashBucketIdExtractor(this.shardManager)));
    }

    public <EntityType, DaoType extends AbstractDAO<EntityType>, T extends Configuration> WrapperDao<EntityType, DaoType> createWrapperDao(Class<DaoType> daoTypeClass, BucketIdExtractor<String> bucketIdExtractor) {
        return new WrapperDao(this.sessionFactories, daoTypeClass, new ShardCalculator<String>(this.shardManager, bucketIdExtractor));
    }

    public <EntityType, DaoType extends AbstractDAO<EntityType>, T extends Configuration> WrapperDao<EntityType, DaoType> createWrapperDao(Class<DaoType> daoTypeClass, Class[] extraConstructorParamClasses, Class[] extraConstructorParamObjects) {
        return new WrapperDao(this.sessionFactories, daoTypeClass, extraConstructorParamClasses, extraConstructorParamObjects, new ShardCalculator<String>(this.shardManager, new ConsistentHashBucketIdExtractor(this.shardManager)));
    }

    private void setupObservers() {
        this.rootObserver = new ListenerTriggeringObserver(new TerminalTransactionObserver()).addListeners(this.listeners);
        for (TransactionObserver observer2 : this.observers) {
            if (null == observer2) {
                return;
            }
            this.rootObserver = observer2.setNext(this.rootObserver);
        }
        this.rootObserver = new FilteringObserver(this.rootObserver).addFilters(this.filters);
        log.debug("Observer chain");
        this.rootObserver.visit(observer -> {
            log.debug(" Observer: {}", (Object)observer.getClass().getSimpleName());
            if (observer instanceof FilteringObserver) {
                log.debug("  Filters:");
                ((FilteringObserver)observer).getFilters().forEach(filter -> log.debug("    - {}", (Object)filter.getClass().getSimpleName()));
            }
            if (observer instanceof ListenerTriggeringObserver) {
                log.debug("  Listeners:");
                ((ListenerTriggeringObserver)observer).getListeners().forEach(filter -> log.debug("    - {}", (Object)filter.getClass().getSimpleName()));
            }
        });
    }

    @Generated
    public List<SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    @Generated
    public ShardManager getShardManager() {
        return this.shardManager;
    }

    @Generated
    public String getDbNamespace() {
        return this.dbNamespace;
    }

    @Generated
    public int getNumShards() {
        return this.numShards;
    }

    @Generated
    public ShardingBundleOptions getShardingOptions() {
        return this.shardingOptions;
    }
}

