/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.utils;

import io.appform.dropwizard.sharding.sharding.BucketIdExtractor;
import io.appform.dropwizard.sharding.sharding.ShardManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardCalculator<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardCalculator.class);
    private final ShardManager shardManager;
    private final BucketIdExtractor<T> extractor;

    public ShardCalculator(ShardManager shardManager, BucketIdExtractor<T> extractor) {
        this.shardManager = shardManager;
        this.extractor = extractor;
    }

    public int shardId(T key) {
        int bucketId = this.extractor.bucketId(key);
        return this.shardManager.shardForBucket(bucketId);
    }

    public boolean isOnValidShard(T key) {
        int bucketId = this.extractor.bucketId(key);
        return this.shardManager.isMappedToValidShard(bucketId);
    }
}

