/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.observers.internal;

import io.appform.dropwizard.sharding.exceptions.TransactionFilteredException;
import io.appform.dropwizard.sharding.execution.TransactionExecutionContext;
import io.appform.dropwizard.sharding.filters.FilterOutput;
import io.appform.dropwizard.sharding.filters.TransactionFilter;
import io.appform.dropwizard.sharding.filters.TransactionFilterResult;
import io.appform.dropwizard.sharding.observers.TransactionObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilteringObserver
extends TransactionObserver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FilteringObserver.class);
    private final List<TransactionFilter> filters = new ArrayList<TransactionFilter>();

    public FilteringObserver(TransactionObserver next) {
        super(next);
    }

    public FilteringObserver addFilters(Collection<TransactionFilter> filters) {
        this.filters.addAll(filters);
        return this;
    }

    @Override
    public final <T> T execute(TransactionExecutionContext context, Supplier<T> supplier) {
        List<String> blocks = this.filters.stream().map(filter -> {
            try {
                return filter.evaluate(context);
            }
            catch (Throwable t) {
                log.error("Error running filter: " + filter.getClass(), t);
                return TransactionFilterResult.allow();
            }
        }).filter(result -> FilterOutput.BLOCK.equals((Object)result.getOutput())).map(TransactionFilterResult::getReason).collect(Collectors.toList());
        if (blocks.isEmpty()) {
            return this.proceed(context, supplier);
        }
        throw new TransactionFilteredException(blocks);
    }

    @Generated
    public List<TransactionFilter> getFilters() {
        return this.filters;
    }
}

