/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.config;

import com.google.common.collect.Lists;
import io.appform.dropwizard.sharding.config.BlacklistConfig;
import io.appform.dropwizard.sharding.config.ShardingBundleOptions;
import io.dropwizard.db.DataSourceFactory;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.NotEmpty;

public class ShardedHibernateFactory {
    @NotNull
    @NotEmpty
    @Valid
    private List<DataSourceFactory> shards = Lists.newArrayList();
    @Valid
    private BlacklistConfig blacklist;
    @Valid
    private ShardingBundleOptions shardingOptions;

    @Generated
    public static ShardedHibernateFactoryBuilder builder() {
        return new ShardedHibernateFactoryBuilder();
    }

    @Generated
    public List<DataSourceFactory> getShards() {
        return this.shards;
    }

    @Generated
    public BlacklistConfig getBlacklist() {
        return this.blacklist;
    }

    @Generated
    public ShardingBundleOptions getShardingOptions() {
        return this.shardingOptions;
    }

    @Generated
    public ShardedHibernateFactory setShards(List<DataSourceFactory> shards) {
        this.shards = shards;
        return this;
    }

    @Generated
    public ShardedHibernateFactory setBlacklist(BlacklistConfig blacklist) {
        this.blacklist = blacklist;
        return this;
    }

    @Generated
    public ShardedHibernateFactory setShardingOptions(ShardingBundleOptions shardingOptions) {
        this.shardingOptions = shardingOptions;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardedHibernateFactory)) {
            return false;
        }
        ShardedHibernateFactory other = (ShardedHibernateFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<DataSourceFactory> this$shards = this.getShards();
        List<DataSourceFactory> other$shards = other.getShards();
        if (this$shards == null ? other$shards != null : !((Object)this$shards).equals(other$shards)) {
            return false;
        }
        BlacklistConfig this$blacklist = this.getBlacklist();
        BlacklistConfig other$blacklist = other.getBlacklist();
        if (this$blacklist == null ? other$blacklist != null : !((Object)this$blacklist).equals(other$blacklist)) {
            return false;
        }
        ShardingBundleOptions this$shardingOptions = this.getShardingOptions();
        ShardingBundleOptions other$shardingOptions = other.getShardingOptions();
        return !(this$shardingOptions == null ? other$shardingOptions != null : !((Object)this$shardingOptions).equals(other$shardingOptions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ShardedHibernateFactory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<DataSourceFactory> $shards = this.getShards();
        result = result * 59 + ($shards == null ? 43 : ((Object)$shards).hashCode());
        BlacklistConfig $blacklist = this.getBlacklist();
        result = result * 59 + ($blacklist == null ? 43 : ((Object)$blacklist).hashCode());
        ShardingBundleOptions $shardingOptions = this.getShardingOptions();
        result = result * 59 + ($shardingOptions == null ? 43 : ((Object)$shardingOptions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ShardedHibernateFactory(shards=" + this.getShards() + ", blacklist=" + this.getBlacklist() + ", shardingOptions=" + this.getShardingOptions() + ")";
    }

    @ConstructorProperties(value={"shards", "blacklist", "shardingOptions"})
    @Generated
    public ShardedHibernateFactory(List<DataSourceFactory> shards, BlacklistConfig blacklist, ShardingBundleOptions shardingOptions) {
        this.shards = shards;
        this.blacklist = blacklist;
        this.shardingOptions = shardingOptions;
    }

    @Generated
    public ShardedHibernateFactory() {
    }

    @Generated
    public static class ShardedHibernateFactoryBuilder {
        @Generated
        private ArrayList<DataSourceFactory> shards;
        @Generated
        private BlacklistConfig blacklist;
        @Generated
        private ShardingBundleOptions shardingOptions;

        @Generated
        ShardedHibernateFactoryBuilder() {
        }

        @Generated
        public ShardedHibernateFactoryBuilder shard(DataSourceFactory shard) {
            if (this.shards == null) {
                this.shards = new ArrayList();
            }
            this.shards.add(shard);
            return this;
        }

        @Generated
        public ShardedHibernateFactoryBuilder shards(Collection<? extends DataSourceFactory> shards) {
            if (shards == null) {
                throw new NullPointerException("shards cannot be null");
            }
            if (this.shards == null) {
                this.shards = new ArrayList();
            }
            this.shards.addAll(shards);
            return this;
        }

        @Generated
        public ShardedHibernateFactoryBuilder clearShards() {
            if (this.shards != null) {
                this.shards.clear();
            }
            return this;
        }

        @Generated
        public ShardedHibernateFactoryBuilder blacklist(BlacklistConfig blacklist) {
            this.blacklist = blacklist;
            return this;
        }

        @Generated
        public ShardedHibernateFactoryBuilder shardingOptions(ShardingBundleOptions shardingOptions) {
            this.shardingOptions = shardingOptions;
            return this;
        }

        @Generated
        public ShardedHibernateFactory build() {
            List<DataSourceFactory> shards;
            switch (this.shards == null ? 0 : this.shards.size()) {
                case 0: {
                    shards = Collections.emptyList();
                    break;
                }
                case 1: {
                    shards = Collections.singletonList(this.shards.get(0));
                    break;
                }
                default: {
                    shards = Collections.unmodifiableList(new ArrayList<DataSourceFactory>(this.shards));
                }
            }
            return new ShardedHibernateFactory(shards, this.blacklist, this.shardingOptions);
        }

        @Generated
        public String toString() {
            return "ShardedHibernateFactory.ShardedHibernateFactoryBuilder(shards=" + this.shards + ", blacklist=" + this.blacklist + ", shardingOptions=" + this.shardingOptions + ")";
        }
    }
}

