/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.healthcheck;

import com.codahale.metrics.health.HealthCheck;
import io.appform.dropwizard.sharding.config.BlacklistConfig;
import io.appform.dropwizard.sharding.sharding.ShardManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlacklistingAwareHealthCheck
extends HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(BlacklistingAwareHealthCheck.class);
    private final int shardId;
    private final HealthCheck baseHealthCheck;
    private final ShardManager shardManager;
    private final BlacklistConfig blacklistConfig;

    public BlacklistingAwareHealthCheck(int shardId, HealthCheck baseHealthCheck, ShardManager shardManager, BlacklistConfig blacklistConfig) {
        this.shardId = shardId;
        this.baseHealthCheck = baseHealthCheck;
        this.shardManager = shardManager;
        this.blacklistConfig = blacklistConfig;
    }

    protected HealthCheck.Result check() {
        if (this.blacklistConfig.isSkipNativeHealthcheck()) {
            return HealthCheck.Result.healthy();
        }
        if (this.shardManager.isBlacklisted(this.shardId)) {
            log.info("returning healthy since shard is blacklisted [{}]", (Object)this.shardId);
            return HealthCheck.Result.healthy();
        }
        HealthCheck.Result result = this.baseHealthCheck.execute();
        log.debug("DBSharding HealthCheck for shardId: {}, Status: {}, {}", new Object[]{this.shardId, result.isHealthy(), result.getMessage()});
        return result;
    }
}

