/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.dao;

import io.appform.dropwizard.sharding.caching.LookupCache;
import io.appform.dropwizard.sharding.dao.LookupDao;
import io.appform.dropwizard.sharding.exceptions.DaoFwdException;
import io.appform.dropwizard.sharding.utils.ShardCalculator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheableLookupDao<T>
extends LookupDao<T> {
    private static final Logger log = LoggerFactory.getLogger(CacheableLookupDao.class);
    private LookupCache<T> cache;

    public CacheableLookupDao(List<SessionFactory> sessionFactories, Class<T> entityClass, ShardCalculator<String> shardCalculator, LookupCache<T> cache) {
        super(sessionFactories, entityClass, shardCalculator);
        this.cache = cache;
    }

    @Override
    public Optional<T> get(String key) throws Exception {
        if (this.cache.exists(key)) {
            return Optional.of(this.cache.get(key));
        }
        Object entity = super.get(key, t -> t);
        if (entity != null) {
            this.cache.put(key, entity);
        }
        return Optional.ofNullable(entity);
    }

    @Override
    public Optional<T> save(T entity) throws Exception {
        Object savedEntity = super.save(entity, t -> t);
        if (savedEntity != null) {
            String key = this.getKeyField().get(entity).toString();
            this.cache.put(key, entity);
        }
        return Optional.ofNullable(savedEntity);
    }

    @Override
    public boolean update(String id, Function<Optional<T>, T> updater) {
        boolean result = super.update(id, updater);
        if (result) {
            try {
                Optional<Object> updatedEntity = super.get(id);
                updatedEntity.ifPresent(t -> this.cache.put(id, t));
            }
            catch (Exception e) {
                throw new DaoFwdException("Error updating entity: " + id, e);
            }
        }
        return result;
    }

    @Override
    public boolean exists(String key) throws Exception {
        if (this.cache.exists(key)) {
            return true;
        }
        Optional<Object> entity = super.get(key);
        entity.ifPresent(t -> this.cache.put(key, t));
        return entity.isPresent();
    }
}

