/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.config;

import com.google.common.collect.Lists;
import io.appform.dropwizard.sharding.config.BlacklistConfig;
import io.dropwizard.db.DataSourceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class ShardedHibernateFactory {
    @NotNull
    @NotEmpty
    @Valid
    private List<DataSourceFactory> shards = Lists.newArrayList();
    @Valid
    private BlacklistConfig blacklist;

    public static ShardedHibernateFactoryBuilder builder() {
        return new ShardedHibernateFactoryBuilder();
    }

    public List<DataSourceFactory> getShards() {
        return this.shards;
    }

    public BlacklistConfig getBlacklist() {
        return this.blacklist;
    }

    public void setShards(List<DataSourceFactory> shards) {
        this.shards = shards;
    }

    public void setBlacklist(BlacklistConfig blacklist) {
        this.blacklist = blacklist;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardedHibernateFactory)) {
            return false;
        }
        ShardedHibernateFactory other = (ShardedHibernateFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<DataSourceFactory> this$shards = this.getShards();
        List<DataSourceFactory> other$shards = other.getShards();
        if (this$shards == null ? other$shards != null : !((Object)this$shards).equals(other$shards)) {
            return false;
        }
        BlacklistConfig this$blacklist = this.getBlacklist();
        BlacklistConfig other$blacklist = other.getBlacklist();
        return !(this$blacklist == null ? other$blacklist != null : !((Object)this$blacklist).equals(other$blacklist));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardedHibernateFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<DataSourceFactory> $shards = this.getShards();
        result = result * 59 + ($shards == null ? 43 : ((Object)$shards).hashCode());
        BlacklistConfig $blacklist = this.getBlacklist();
        result = result * 59 + ($blacklist == null ? 43 : ((Object)$blacklist).hashCode());
        return result;
    }

    public String toString() {
        return "ShardedHibernateFactory(shards=" + this.getShards() + ", blacklist=" + this.getBlacklist() + ")";
    }

    public ShardedHibernateFactory(List<DataSourceFactory> shards, BlacklistConfig blacklist) {
        this.shards = shards;
        this.blacklist = blacklist;
    }

    public ShardedHibernateFactory() {
    }

    public static class ShardedHibernateFactoryBuilder {
        private ArrayList<DataSourceFactory> shards;
        private BlacklistConfig blacklist;

        ShardedHibernateFactoryBuilder() {
        }

        public ShardedHibernateFactoryBuilder shard(DataSourceFactory shard) {
            if (this.shards == null) {
                this.shards = new ArrayList();
            }
            this.shards.add(shard);
            return this;
        }

        public ShardedHibernateFactoryBuilder shards(Collection<? extends DataSourceFactory> shards) {
            if (this.shards == null) {
                this.shards = new ArrayList();
            }
            this.shards.addAll(shards);
            return this;
        }

        public ShardedHibernateFactoryBuilder clearShards() {
            if (this.shards != null) {
                this.shards.clear();
            }
            return this;
        }

        public ShardedHibernateFactoryBuilder blacklist(BlacklistConfig blacklist) {
            this.blacklist = blacklist;
            return this;
        }

        public ShardedHibernateFactory build() {
            List<DataSourceFactory> shards;
            switch (this.shards == null ? 0 : this.shards.size()) {
                case 0: {
                    shards = Collections.emptyList();
                    break;
                }
                case 1: {
                    shards = Collections.singletonList(this.shards.get(0));
                    break;
                }
                default: {
                    shards = Collections.unmodifiableList(new ArrayList<DataSourceFactory>(this.shards));
                }
            }
            return new ShardedHibernateFactory(shards, this.blacklist);
        }

        public String toString() {
            return "ShardedHibernateFactory.ShardedHibernateFactoryBuilder(shards=" + this.shards + ", blacklist=" + this.blacklist + ")";
        }
    }
}

