/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.sharding;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.appform.dropwizard.sharding.exceptions.ShardBlacklistedException;
import io.appform.dropwizard.sharding.sharding.ShardBlacklistingStore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShardManager {
    private static final Logger log = LoggerFactory.getLogger(ShardManager.class);
    private final ShardBlacklistingStore shardBlacklistingStore;
    private LoadingCache<Integer, Boolean> blackListedShards;

    public abstract int numBuckets();

    protected abstract int numShards();

    protected abstract int shardForBucketImpl(int var1);

    protected ShardManager(ShardBlacklistingStore shardBlacklistingStore) {
        this.shardBlacklistingStore = shardBlacklistingStore;
        this.blackListedShards = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(5L, TimeUnit.MINUTES).refreshAfterWrite(1L, TimeUnit.MINUTES).build(shardBlacklistingStore::blacklisted);
    }

    public int shardForBucket(int bucketId) {
        int shard = this.shardForBucketImpl(bucketId);
        Boolean isBlacklisted = (Boolean)this.blackListedShards.get((Object)shard);
        if (null != isBlacklisted && isBlacklisted.booleanValue()) {
            throw new ShardBlacklistedException(shard);
        }
        return shard;
    }

    public boolean isMappedToValidShard(int bucketId) {
        int shard = this.shardForBucketImpl(bucketId);
        Boolean isBlacklisted = (Boolean)this.blackListedShards.get((Object)shard);
        return null == isBlacklisted || isBlacklisted == false;
    }

    public void blacklistShard(int shardId) {
        if (shardId >= 0 && shardId < this.numShards()) {
            this.shardBlacklistingStore.blacklist(shardId);
            this.blackListedShards.refresh((Object)shardId);
        }
    }

    public boolean isBlacklisted(int shardId) {
        if (shardId >= 0 && shardId < this.numShards() && this.shardBlacklistingStore != null) {
            return this.shardBlacklistingStore.blacklisted(shardId);
        }
        return false;
    }

    public void unblacklistShard(int shardId) {
        if (shardId >= 0 && shardId < this.numShards()) {
            this.shardBlacklistingStore.unblacklist(shardId);
            this.blackListedShards.refresh((Object)shardId);
        }
    }

    public String toString() {
        return "ShardManager(shardBlacklistingStore=" + this.shardBlacklistingStore + ", blackListedShards=" + this.blackListedShards + ")";
    }
}

