/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding;

import com.codahale.metrics.health.HealthCheckRegistryListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.appform.dropwizard.sharding.ShardInfoProvider;
import io.appform.dropwizard.sharding.admin.BlacklistShardTask;
import io.appform.dropwizard.sharding.admin.UnblacklistShardTask;
import io.appform.dropwizard.sharding.caching.LookupCache;
import io.appform.dropwizard.sharding.caching.RelationalCache;
import io.appform.dropwizard.sharding.config.ShardedHibernateFactory;
import io.appform.dropwizard.sharding.dao.CacheableLookupDao;
import io.appform.dropwizard.sharding.dao.CacheableRelationalDao;
import io.appform.dropwizard.sharding.dao.LookupDao;
import io.appform.dropwizard.sharding.dao.RelationalDao;
import io.appform.dropwizard.sharding.dao.WrapperDao;
import io.appform.dropwizard.sharding.healthcheck.HealthCheckManager;
import io.appform.dropwizard.sharding.sharding.BucketIdExtractor;
import io.appform.dropwizard.sharding.sharding.InMemoryLocalShardBlacklistingStore;
import io.appform.dropwizard.sharding.sharding.ShardBlacklistingStore;
import io.appform.dropwizard.sharding.sharding.ShardManager;
import io.appform.dropwizard.sharding.sharding.impl.ConsistentHashBucketIdExtractor;
import io.appform.dropwizard.sharding.utils.ShardCalculator;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.hibernate.AbstractDAO;
import io.dropwizard.hibernate.HibernateBundle;
import io.dropwizard.hibernate.SessionFactoryFactory;
import io.dropwizard.servlets.tasks.Task;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.persistence.Entity;
import org.hibernate.SessionFactory;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DBShardingBundleBase<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger log = LoggerFactory.getLogger(DBShardingBundleBase.class);
    private static final String DEFAULT_NAMESPACE = "default";
    private static final String SHARD_ENV = "db.shards";
    private static final String DEFAULT_SHARDS = "2";
    private List<HibernateBundle<T>> shardBundles = Lists.newArrayList();
    private List<SessionFactory> sessionFactories;
    private ShardManager shardManager;
    private String dbNamespace;
    private int numShards;
    private ShardInfoProvider shardInfoProvider;
    private HealthCheckManager healthCheckManager;

    protected DBShardingBundleBase(String dbNamespace, Class<?> entity, Class<?> ... entities) {
        this.dbNamespace = dbNamespace;
        this.shardInfoProvider = new ShardInfoProvider(dbNamespace);
        this.healthCheckManager = new HealthCheckManager(dbNamespace, this.shardManager, this.shardInfoProvider);
        ImmutableList inEntities = ImmutableList.builder().add(entity).add((Object[])entities).build();
        this.init(inEntities);
    }

    protected DBShardingBundleBase(String dbNamespace, List<String> classPathPrefixList) {
        this.dbNamespace = dbNamespace;
        Set entities = new Reflections(new Object[]{classPathPrefixList}).getTypesAnnotatedWith(Entity.class);
        Preconditions.checkArgument((!entities.isEmpty() ? 1 : 0) != 0, (Object)String.format("No entity class found at %s", String.join((CharSequence)",", classPathPrefixList)));
        ImmutableList inEntities = ImmutableList.builder().addAll((Iterable)entities).build();
        this.init(inEntities);
    }

    protected DBShardingBundleBase(Class<?> entity, Class<?> ... entities) {
        this(DEFAULT_NAMESPACE, entity, entities);
    }

    protected DBShardingBundleBase(String ... classPathPrefixes) {
        this(DEFAULT_NAMESPACE, Arrays.asList(classPathPrefixes));
    }

    protected abstract ShardManager createShardManager(int var1, ShardBlacklistingStore var2);

    private void init(ImmutableList<Class<?>> inEntities) {
        String numShardsEnv = System.getProperty(String.join((CharSequence)".", this.dbNamespace, DEFAULT_NAMESPACE), System.getProperty(SHARD_ENV, DEFAULT_SHARDS));
        this.numShards = Integer.parseInt(numShardsEnv);
        ShardBlacklistingStore blacklistingStore = this.getBlacklistingStore();
        this.shardManager = this.createShardManager(this.numShards, blacklistingStore);
        this.shardInfoProvider = new ShardInfoProvider(this.dbNamespace);
        this.healthCheckManager = new HealthCheckManager(this.dbNamespace, this.shardManager, this.shardInfoProvider);
        IntStream.range(0, this.numShards).forEach(shard -> this.shardBundles.add(new HibernateBundle<T>(inEntities, new SessionFactoryFactory()){

            protected String name() {
                return DBShardingBundleBase.this.shardInfoProvider.shardName(shard);
            }

            public PooledDataSourceFactory getDataSourceFactory(T t) {
                return (PooledDataSourceFactory)DBShardingBundleBase.this.getConfig(t).getShards().get(shard);
            }
        }));
    }

    public void run(T configuration, Environment environment) {
        this.sessionFactories = this.shardBundles.stream().map(HibernateBundle::getSessionFactory).collect(Collectors.toList());
        environment.admin().addTask((Task)new BlacklistShardTask(this.shardManager));
        environment.admin().addTask((Task)new UnblacklistShardTask(this.shardManager));
        this.healthCheckManager.manageHealthChecks(environment);
    }

    public void initialize(Bootstrap<?> bootstrap) {
        bootstrap.getHealthCheckRegistry().addListener((HealthCheckRegistryListener)this.healthCheckManager);
        this.shardBundles.forEach(hibernateBundle -> bootstrap.addBundle((ConfiguredBundle)hibernateBundle));
    }

    @VisibleForTesting
    public void runBundles(T configuration, Environment environment) {
        this.shardBundles.forEach(hibernateBundle -> {
            try {
                hibernateBundle.run(configuration, environment);
            }
            catch (Exception e) {
                log.error("Error initializing db sharding bundle", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    @VisibleForTesting
    public void initBundles(Bootstrap bootstrap) {
        this.shardBundles.forEach(hibernameBundle -> this.initialize(bootstrap));
    }

    @VisibleForTesting
    public Map<Integer, Boolean> healthStatus() {
        return this.healthCheckManager.status();
    }

    protected abstract ShardedHibernateFactory getConfig(T var1);

    protected ShardBlacklistingStore getBlacklistingStore() {
        return new InMemoryLocalShardBlacklistingStore();
    }

    public static <EntityType, T extends Configuration> LookupDao<EntityType> createParentObjectDao(DBShardingBundleBase<T> bundle, Class<EntityType> clazz) {
        return new LookupDao<EntityType>(bundle.sessionFactories, clazz, new ShardCalculator<String>(bundle.shardManager, new ConsistentHashBucketIdExtractor(bundle.shardManager)));
    }

    public static <EntityType, T extends Configuration> CacheableLookupDao<EntityType> createParentObjectDao(DBShardingBundleBase<T> bundle, Class<EntityType> clazz, LookupCache<EntityType> cacheManager) {
        return new CacheableLookupDao<EntityType>(bundle.sessionFactories, clazz, new ShardCalculator<String>(bundle.shardManager, new ConsistentHashBucketIdExtractor(bundle.shardManager)), cacheManager);
    }

    public static <EntityType, T extends Configuration> LookupDao<EntityType> createParentObjectDao(DBShardingBundleBase<T> bundle, Class<EntityType> clazz, BucketIdExtractor<String> bucketIdExtractor) {
        return new LookupDao<EntityType>(bundle.sessionFactories, clazz, new ShardCalculator<String>(bundle.shardManager, bucketIdExtractor));
    }

    public static <EntityType, T extends Configuration> CacheableLookupDao<EntityType> createParentObjectDao(DBShardingBundleBase<T> bundle, Class<EntityType> clazz, BucketIdExtractor<String> bucketIdExtractor, LookupCache<EntityType> cacheManager) {
        return new CacheableLookupDao<EntityType>(bundle.sessionFactories, clazz, new ShardCalculator<String>(bundle.shardManager, bucketIdExtractor), cacheManager);
    }

    public static <EntityType, T extends Configuration> RelationalDao<EntityType> createRelatedObjectDao(DBShardingBundleBase<T> bundle, Class<EntityType> clazz) {
        return new RelationalDao<EntityType>(bundle.sessionFactories, clazz, new ShardCalculator<String>(bundle.shardManager, new ConsistentHashBucketIdExtractor(bundle.shardManager)));
    }

    public static <EntityType, T extends Configuration> CacheableRelationalDao<EntityType> createRelatedObjectDao(DBShardingBundleBase<T> bundle, Class<EntityType> clazz, RelationalCache<EntityType> cacheManager) {
        return new CacheableRelationalDao<EntityType>(bundle.sessionFactories, clazz, new ShardCalculator<String>(bundle.shardManager, new ConsistentHashBucketIdExtractor(bundle.shardManager)), cacheManager);
    }

    public static <EntityType, T extends Configuration> RelationalDao<EntityType> createRelatedObjectDao(DBShardingBundleBase<T> bundle, Class<EntityType> clazz, BucketIdExtractor<String> bucketIdExtractor) {
        return new RelationalDao<EntityType>(bundle.sessionFactories, clazz, new ShardCalculator<String>(bundle.shardManager, bucketIdExtractor));
    }

    public static <EntityType, T extends Configuration> CacheableRelationalDao<EntityType> createRelatedObjectDao(DBShardingBundleBase<T> bundle, Class<EntityType> clazz, BucketIdExtractor<String> bucketIdExtractor, RelationalCache<EntityType> cacheManager) {
        return new CacheableRelationalDao<EntityType>(bundle.sessionFactories, clazz, new ShardCalculator<String>(bundle.shardManager, bucketIdExtractor), cacheManager);
    }

    public static <EntityType, DaoType extends AbstractDAO<EntityType>, T extends Configuration> WrapperDao<EntityType, DaoType> createWrapperDao(DBShardingBundleBase<T> bundle, Class<DaoType> daoTypeClass) {
        return new WrapperDao(bundle.sessionFactories, daoTypeClass, new ShardCalculator<String>(bundle.shardManager, new ConsistentHashBucketIdExtractor(bundle.shardManager)));
    }

    public static <EntityType, DaoType extends AbstractDAO<EntityType>, T extends Configuration> WrapperDao<EntityType, DaoType> createWrapperDao(DBShardingBundleBase<T> bundle, Class<DaoType> daoTypeClass, BucketIdExtractor<String> bucketIdExtractor) {
        return new WrapperDao(bundle.sessionFactories, daoTypeClass, new ShardCalculator<String>(bundle.shardManager, bucketIdExtractor));
    }

    public static <EntityType, DaoType extends AbstractDAO<EntityType>, T extends Configuration> WrapperDao<EntityType, DaoType> createWrapperDao(DBShardingBundleBase<T> bundle, Class<DaoType> daoTypeClass, Class[] extraConstructorParamClasses, Class[] extraConstructorParamObjects) {
        return new WrapperDao(bundle.sessionFactories, daoTypeClass, extraConstructorParamClasses, extraConstructorParamObjects, new ShardCalculator<String>(bundle.shardManager, new ConsistentHashBucketIdExtractor(bundle.shardManager)));
    }

    public List<SessionFactory> getSessionFactories() {
        return this.sessionFactories;
    }

    public ShardManager getShardManager() {
        return this.shardManager;
    }

    public String getDbNamespace() {
        return this.dbNamespace;
    }

    public int getNumShards() {
        return this.numShards;
    }
}

