/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.sharding;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import io.appform.dropwizard.sharding.sharding.InMemoryLocalShardBlacklistingStore;
import io.appform.dropwizard.sharding.sharding.ShardBlacklistingStore;
import io.appform.dropwizard.sharding.sharding.ShardManager;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyShardManager
extends ShardManager {
    private static final Logger log = LoggerFactory.getLogger(LegacyShardManager.class);
    private static final int MIN_BUCKET = 0;
    private static final int MAX_BUCKET = 999;
    private final int numShards;
    private RangeMap<Integer, Integer> buckets = TreeRangeMap.create();

    public LegacyShardManager(int numShards) {
        this(numShards, new InMemoryLocalShardBlacklistingStore());
    }

    public LegacyShardManager(int numShards, ShardBlacklistingStore shardBlacklistingStore) {
        super(shardBlacklistingStore);
        Preconditions.checkArgument((numShards > 1 && (numShards & numShards - 1) == 0 ? 1 : 0) != 0, (Object)"Shard manager only support 2^n shards. Also it is senseless to use anything other than 2^n shards for scale out.");
        this.numShards = numShards;
        TreeRangeMap assignedBuckets = TreeRangeMap.create();
        int interval = 999 / numShards;
        log.trace("Interval: {}", (Object)interval);
        int shardCounter = 0;
        boolean endReached = false;
        boolean altAssignment = 999 - interval * numShards > interval;
        int start = 0;
        while (!endReached) {
            int remaining = 999 - start;
            log.trace("Remaining: {}. Interval: {}, 2x Interval: {}", new Object[]{remaining, interval, 2 * interval});
            int end = start + interval - 1;
            endReached = shardCounter == numShards - 1;
            end = endReached ? 999 : end;
            log.trace("Assigning {} elements, from {} to {} into shard {}", new Object[]{end - start + 1, start, end, shardCounter});
            assignedBuckets.put(Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)), (Object)shardCounter);
            start += interval;
            ++shardCounter;
        }
        Preconditions.checkArgument((assignedBuckets.asMapOfRanges().size() == numShards ? 1 : 0) != 0, (Object)"There is an issue in shard allocation. Not all shards have been allocated to. Please contact devs.");
        this.buckets.putAll((RangeMap)assignedBuckets);
        log.info("Buckets to shard allocation: {}", this.buckets);
    }

    @Override
    public int numBuckets() {
        return 1000;
    }

    @Override
    public int numShards() {
        return this.numShards;
    }

    @Override
    protected int shardForBucketImpl(int bucketId) {
        Preconditions.checkArgument((bucketId >= 0 && bucketId <= 999 ? 1 : 0) != 0, (Object)"Bucket id can only be in the range of [1-1000] (inclusive)");
        Map.Entry entry = this.buckets.getEntry((Comparable)Integer.valueOf(bucketId));
        if (null == entry) {
            throw new IllegalAccessError("Bucket not mapped to any shard");
        }
        return (Integer)entry.getValue();
    }

    public static LegacyShardManagerBuilder builder() {
        return new LegacyShardManagerBuilder();
    }

    @Override
    public String toString() {
        return "LegacyShardManager(numShards=" + this.numShards + ", buckets=" + this.buckets + ")";
    }

    public static class LegacyShardManagerBuilder {
        private int numShards;
        private ShardBlacklistingStore shardBlacklistingStore;

        LegacyShardManagerBuilder() {
        }

        public LegacyShardManagerBuilder numShards(int numShards) {
            this.numShards = numShards;
            return this;
        }

        public LegacyShardManagerBuilder shardBlacklistingStore(ShardBlacklistingStore shardBlacklistingStore) {
            this.shardBlacklistingStore = shardBlacklistingStore;
            return this;
        }

        public LegacyShardManager build() {
            return new LegacyShardManager(this.numShards, this.shardBlacklistingStore);
        }

        public String toString() {
            return "LegacyShardManager.LegacyShardManagerBuilder(numShards=" + this.numShards + ", shardBlacklistingStore=" + this.shardBlacklistingStore + ")";
        }
    }
}

