/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.healthcheck;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistryListener;
import io.appform.dropwizard.sharding.ShardInfoProvider;
import io.appform.dropwizard.sharding.healthcheck.BlacklistingAwareHealthCheck;
import io.appform.dropwizard.sharding.healthcheck.ShardHealthCheckMeta;
import io.appform.dropwizard.sharding.sharding.ShardManager;
import io.dropwizard.hibernate.SessionFactoryHealthCheck;
import io.dropwizard.setup.Environment;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckManager
implements HealthCheckRegistryListener {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckManager.class);
    private final String namespace;
    private final ShardManager shardManager;
    private final Map<String, ShardHealthCheckMeta> dbHealthChecks = new HashMap<String, ShardHealthCheckMeta>();
    private final Map<String, ShardHealthCheckMeta> wrappedHealthChecks = new HashMap<String, ShardHealthCheckMeta>();
    private final ShardInfoProvider shardInfoProvider;

    public HealthCheckManager(String namespace, ShardManager shardManager, ShardInfoProvider shardInfoProvider) {
        this.namespace = namespace;
        this.shardManager = shardManager;
        this.shardInfoProvider = shardInfoProvider;
    }

    public void onHealthCheckAdded(String name, HealthCheck healthCheck) {
        if (!(healthCheck instanceof SessionFactoryHealthCheck)) {
            return;
        }
        String dbNamespace = this.shardInfoProvider.namespace(name);
        if (!Objects.equals(dbNamespace, this.namespace)) {
            return;
        }
        int shardId = this.shardInfoProvider.shardId(name);
        if (shardId == -1) {
            return;
        }
        log.info("db health check added {}", (Object)shardId);
        this.dbHealthChecks.put(name, ShardHealthCheckMeta.builder().healthCheck(healthCheck).shardId(shardId).build());
    }

    public void onHealthCheckRemoved(String s, HealthCheck healthCheck) {
    }

    public void manageHealthChecks(Environment environment) {
        this.dbHealthChecks.forEach((name, healthCheck) -> {
            environment.healthChecks().unregister(name);
            BlacklistingAwareHealthCheck hc = new BlacklistingAwareHealthCheck(healthCheck.getShardId(), healthCheck.getHealthCheck(), this.shardManager);
            environment.healthChecks().register(name, (HealthCheck)hc);
            this.wrappedHealthChecks.put((String)name, ShardHealthCheckMeta.builder().healthCheck(hc).shardId(healthCheck.getShardId()).build());
        });
    }

    public Map<Integer, Boolean> status() {
        return this.wrappedHealthChecks.values().stream().map(shardHealthCheckMeta -> new AbstractMap.SimpleEntry<Integer, Boolean>(shardHealthCheckMeta.getShardId(), shardHealthCheckMeta.getHealthCheck().execute().isHealthy())).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }
}

