/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.dao;

import io.appform.dropwizard.sharding.dao.ShardedDao;
import io.appform.dropwizard.sharding.sharding.ShardedTransaction;
import io.appform.dropwizard.sharding.utils.ShardCalculator;
import io.appform.dropwizard.sharding.utils.TransactionHandler;
import io.dropwizard.hibernate.AbstractDAO;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.apache.commons.lang3.ArrayUtils;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrapperDao<T, DaoType extends AbstractDAO<T>>
implements ShardedDao<T> {
    private static final Logger log = LoggerFactory.getLogger(WrapperDao.class);
    private List<DaoType> daos;
    private final ShardCalculator<String> shardCalculator;

    public WrapperDao(List<SessionFactory> sessionFactories, Class<DaoType> daoClass, ShardCalculator<String> shardCalculator) {
        this(sessionFactories, daoClass, null, null, shardCalculator);
    }

    public WrapperDao(List<SessionFactory> sessionFactories, Class<DaoType> daoClass, Class[] extraConstructorParamClasses, Class[] extraConstructorParamObjects, ShardCalculator<String> shardCalculator) {
        this.shardCalculator = shardCalculator;
        this.daos = sessionFactories.stream().map(sessionFactory -> {
            Enhancer enhancer = new Enhancer();
            enhancer.setUseFactory(false);
            enhancer.setSuperclass(daoClass);
            enhancer.setCallback((Callback)((MethodInterceptor)(obj, method, args, proxy) -> {
                ShardedTransaction transaction = method.getAnnotation(ShardedTransaction.class);
                if (null == transaction) {
                    return proxy.invokeSuper(obj, args);
                }
                TransactionHandler transactionHandler = new TransactionHandler((SessionFactory)sessionFactory, transaction.readOnly());
                try {
                    transactionHandler.beforeStart();
                    Object result = proxy.invokeSuper(obj, args);
                    transactionHandler.afterEnd();
                    return result;
                }
                catch (InvocationTargetException e) {
                    transactionHandler.onError();
                    throw e.getCause();
                }
                catch (Exception e) {
                    transactionHandler.onError();
                    throw e;
                }
            }));
            return this.createDAOProxy((SessionFactory)sessionFactory, enhancer, extraConstructorParamClasses, extraConstructorParamObjects);
        }).collect(Collectors.toList());
    }

    public DaoType forParent(String parentKey) {
        return (DaoType)((AbstractDAO)this.daos.get(this.shardCalculator.shardId(parentKey)));
    }

    private DaoType createDAOProxy(SessionFactory sessionFactory, Enhancer enhancer, Class[] extraConstructorParamClasses, Class[] extraConstructorParamObjects) {
        Object[] constructorClasses = new Class[]{SessionFactory.class};
        if (null != extraConstructorParamClasses) {
            ArrayUtils.addAll((Object[])constructorClasses, (Object[])extraConstructorParamClasses);
        }
        Object[] constructorObjects = new Object[]{sessionFactory};
        if (null != extraConstructorParamObjects) {
            ArrayUtils.addAll((Object[])constructorObjects, (Object[])extraConstructorParamClasses);
        }
        return (DaoType)((AbstractDAO)enhancer.create((Class[])constructorClasses, constructorObjects));
    }

    @Override
    public ShardCalculator<String> getShardCalculator() {
        return this.shardCalculator;
    }
}

