/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.sharding.config;

import com.google.common.collect.Lists;
import io.dropwizard.db.DataSourceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class ShardedHibernateFactory {
    @NotNull
    @NotEmpty
    @Valid
    private List<DataSourceFactory> shards = Lists.newArrayList();

    public static ShardedHibernateFactoryBuilder builder() {
        return new ShardedHibernateFactoryBuilder();
    }

    public List<DataSourceFactory> getShards() {
        return this.shards;
    }

    public void setShards(List<DataSourceFactory> shards) {
        this.shards = shards;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardedHibernateFactory)) {
            return false;
        }
        ShardedHibernateFactory other = (ShardedHibernateFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<DataSourceFactory> this$shards = this.getShards();
        List<DataSourceFactory> other$shards = other.getShards();
        return !(this$shards == null ? other$shards != null : !((Object)this$shards).equals(other$shards));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardedHibernateFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<DataSourceFactory> $shards = this.getShards();
        result = result * 59 + ($shards == null ? 43 : ((Object)$shards).hashCode());
        return result;
    }

    public String toString() {
        return "ShardedHibernateFactory(shards=" + this.getShards() + ")";
    }

    public ShardedHibernateFactory(List<DataSourceFactory> shards) {
        this.shards = shards;
    }

    public ShardedHibernateFactory() {
    }

    public static class ShardedHibernateFactoryBuilder {
        private ArrayList<DataSourceFactory> shards;

        ShardedHibernateFactoryBuilder() {
        }

        public ShardedHibernateFactoryBuilder shard(DataSourceFactory shard) {
            if (this.shards == null) {
                this.shards = new ArrayList();
            }
            this.shards.add(shard);
            return this;
        }

        public ShardedHibernateFactoryBuilder shards(Collection<? extends DataSourceFactory> shards) {
            if (this.shards == null) {
                this.shards = new ArrayList();
            }
            this.shards.addAll(shards);
            return this;
        }

        public ShardedHibernateFactoryBuilder clearShards() {
            if (this.shards != null) {
                this.shards.clear();
            }
            return this;
        }

        public ShardedHibernateFactory build() {
            List<DataSourceFactory> shards;
            switch (this.shards == null ? 0 : this.shards.size()) {
                case 0: {
                    shards = Collections.emptyList();
                    break;
                }
                case 1: {
                    shards = Collections.singletonList(this.shards.get(0));
                    break;
                }
                default: {
                    shards = Collections.unmodifiableList(new ArrayList<DataSourceFactory>(this.shards));
                }
            }
            return new ShardedHibernateFactory(shards);
        }

        public String toString() {
            return "ShardedHibernateFactory.ShardedHibernateFactoryBuilder(shards=" + this.shards + ")";
        }
    }
}

