/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.multiauth.integration;

import io.appform.dropwizard.multiauth.configs.AuthConfig;
import io.appform.dropwizard.multiauth.exception.JWTAuthenticationFailure;
import io.appform.dropwizard.multiauth.integration.SessionUser;
import io.appform.dropwizard.multiauth.model.DefaultHandler;
import io.appform.dropwizard.multiauth.model.ServiceUserPrincipal;
import io.dropwizard.auth.Authorizer;
import java.io.IOException;
import java.security.Principal;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.SecurityContext;

@Priority(value=1000)
public class UserAuthorizationFilter
implements ContainerRequestFilter {
    private final AuthConfig authConfig;
    private final Authorizer<ServiceUserPrincipal> authorizer;
    private final DefaultHandler defaultHandler;

    public UserAuthorizationFilter(AuthConfig authConfig, Authorizer<ServiceUserPrincipal> authorizer, DefaultHandler defaultHandler) {
        this.authConfig = authConfig;
        this.authorizer = authorizer;
        this.defaultHandler = defaultHandler;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!this.authConfig.isEnabled()) {
            this.updateContext(requestContext, this.defaultHandler.defaultUser().orElse(null));
            return;
        }
        ServiceUserPrincipal principal = SessionUser.take();
        if (null != principal) {
            this.updateContext(requestContext, principal);
            return;
        }
        throw new JWTAuthenticationFailure();
    }

    private void updateContext(final ContainerRequestContext requestContext, final ServiceUserPrincipal principal) {
        requestContext.setSecurityContext(new SecurityContext(){

            public Principal getUserPrincipal() {
                return principal;
            }

            public boolean isUserInRole(String role) {
                return UserAuthorizationFilter.this.authorizer.authorize((Principal)principal, role);
            }

            public boolean isSecure() {
                return requestContext.getSecurityContext().isSecure();
            }

            public String getAuthenticationScheme() {
                return "BASIC";
            }
        });
    }
}

