/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.multiauth.integration;

import com.google.common.base.Strings;
import io.appform.dropwizard.multiauth.configs.AuthConfig;
import io.appform.dropwizard.multiauth.configs.JwtConfig;
import io.appform.dropwizard.multiauth.core.TokenAuthenticator;
import io.appform.dropwizard.multiauth.integration.SessionUser;
import io.appform.dropwizard.multiauth.model.ServiceUserPrincipal;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.keys.HmacKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
@WebFilter(value={"/*"})
@Singleton
public class UserAuthenticationFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(UserAuthenticationFilter.class);
    private final AuthConfig authConfig;
    private final JwtConsumer consumer;
    private final Authenticator<JwtContext, ServiceUserPrincipal> authenticator;
    private final List<String> allowedPatterns;

    @Inject
    public UserAuthenticationFilter(AuthConfig authConfig, TokenAuthenticator authenticator) {
        this.authConfig = authConfig;
        this.consumer = this.buildConsumer(authConfig);
        this.authenticator = authenticator;
        this.allowedPatterns = null != authConfig.getAllowedPatterns() ? authConfig.getAllowedPatterns() : Collections.emptyList();
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String referrer;
        if (!this.authConfig.isEnabled()) {
            log.trace("Auth disabled");
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestURI = httpRequest.getRequestURI();
        if (this.allowedPatterns.stream().anyMatch(requestURI::startsWith) || requestURI.startsWith("/auth/google")) {
            chain.doFilter(request, response);
            return;
        }
        String jwt = this.getTokenFromCookieOrHeader(httpRequest).orElse(null);
        if (null != jwt) {
            try {
                JwtContext context = this.consumer.process(jwt);
                ServiceUserPrincipal principal = this.authenticator.authenticate((Object)context).orElse(null);
                if (null != principal) {
                    SessionUser.put(principal);
                    chain.doFilter(request, response);
                    return;
                }
            }
            catch (AuthenticationException | InvalidJwtException e) {
                log.error("Jwt validation failure: ", e);
            }
        }
        String source = Strings.isNullOrEmpty((String)(referrer = httpRequest.getHeader("Referer"))) ? requestURI : referrer;
        httpResponse.addCookie(new Cookie("redirection", source));
        httpResponse.sendRedirect("/auth/google/login");
    }

    public void destroy() {
    }

    private Optional<String> getTokenFromCookieOrHeader(HttpServletRequest servletRequest) {
        Optional<String> tokenFromHeader = this.getTokenFromHeader(servletRequest);
        return tokenFromHeader.isPresent() ? tokenFromHeader : this.getTokenFromCookie(servletRequest);
    }

    private Optional<String> getTokenFromHeader(HttpServletRequest servletRequest) {
        String method;
        int space;
        String header = servletRequest.getHeader("Authorization");
        if (header != null && (space = header.indexOf(32)) > 0 && "Bearer".equalsIgnoreCase(method = header.substring(0, space))) {
            String rawToken = header.substring(space + 1);
            return Optional.of(rawToken);
        }
        return Optional.empty();
    }

    private Optional<String> getTokenFromCookie(HttpServletRequest request) {
        Cookie token;
        Cookie[] cookies = request.getCookies();
        if (null != cookies && cookies.length != 0 && null != (token = (Cookie)Arrays.stream(cookies).filter(cookie -> cookie.getName().equals("token")).findAny().orElse(null))) {
            return Optional.of(token.getValue());
        }
        return Optional.empty();
    }

    private JwtConsumer buildConsumer(AuthConfig authConfig) {
        JwtConfig jwtConfig = authConfig.getJwt();
        byte[] secretKey = jwtConfig.getPrivateKey().getBytes(StandardCharsets.UTF_8);
        return new JwtConsumerBuilder().setRequireIssuedAt().setRequireSubject().setExpectedIssuer(jwtConfig.getIssuerId()).setVerificationKey((Key)new HmacKey(secretKey)).setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, new String[]{"HS512"})).setExpectedAudience(new String[]{jwtConfig.getServiceName()}).build();
    }
}

