/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.multiauth.integration;

import io.appform.dropwizard.multiauth.model.ServiceUserPrincipal;
import java.io.Serializable;

public class SessionUser
implements Serializable {
    private static final long serialVersionUID = -7917711435258380077L;
    private final ServiceUserPrincipal user;
    private static ThreadLocal<ServiceUserPrincipal> currentUser = new ThreadLocal();

    public static void put(ServiceUserPrincipal user) {
        currentUser.set(user);
    }

    public static ServiceUserPrincipal take() {
        ServiceUserPrincipal user = currentUser.get();
        currentUser.remove();
        return user;
    }

    SessionUser(ServiceUserPrincipal user) {
        this.user = user;
    }

    public static SessionUserBuilder builder() {
        return new SessionUserBuilder();
    }

    public ServiceUserPrincipal getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SessionUser)) {
            return false;
        }
        SessionUser other = (SessionUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ServiceUserPrincipal this$user = this.getUser();
        ServiceUserPrincipal other$user = other.getUser();
        return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SessionUser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ServiceUserPrincipal $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        return result;
    }

    public String toString() {
        return "SessionUser(user=" + this.getUser() + ")";
    }

    public static class SessionUserBuilder {
        private ServiceUserPrincipal user;

        SessionUserBuilder() {
        }

        public SessionUserBuilder user(ServiceUserPrincipal user) {
            this.user = user;
            return this;
        }

        public SessionUser build() {
            return new SessionUser(this.user);
        }

        public String toString() {
            return "SessionUser.SessionUserBuilder(user=" + this.user + ")";
        }
    }
}

