/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.multiauth.core;

import io.appform.dropwizard.multiauth.configs.AuthConfig;
import io.appform.dropwizard.multiauth.configs.JwtConfig;
import io.appform.dropwizard.multiauth.model.Token;
import io.dropwizard.util.Duration;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.keys.HmacKey;

public final class Utils {
    public static String createJWT(Token token, JwtConfig jwtConfig) {
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(jwtConfig.getIssuerId());
        claims.setGeneratedJwtId();
        claims.setIssuedAtToNow();
        claims.setJwtId(token.getId());
        claims.setNotBeforeMinutesInThePast(2.0f);
        claims.setSubject(token.getUserId());
        claims.setAudience(jwtConfig.getServiceName());
        if (null != token.getExpiry()) {
            claims.setExpirationTime(NumericDate.fromMilliseconds((long)token.getExpiry().getTime()));
        }
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        byte[] secretKey = jwtConfig.getPrivateKey().getBytes(StandardCharsets.UTF_8);
        jws.setKey((Key)new HmacKey(secretKey));
        jws.setAlgorithmHeaderValue("HS512");
        return jws.getCompactSerialization();
    }

    public static Duration sessionDuration(AuthConfig authConfig) {
        Duration dynamicSessionDuration = authConfig.getJwt().getSessionDuration();
        return dynamicSessionDuration != null ? dynamicSessionDuration : Duration.days((long)30L);
    }

    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

