/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.multiauth.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeTokenRequest;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.appform.dropwizard.multiauth.configs.AuthConfig;
import io.appform.dropwizard.multiauth.configs.MultiAuthConfig;
import io.appform.dropwizard.multiauth.core.AuthProvider;
import io.appform.dropwizard.multiauth.core.Utils;
import io.appform.dropwizard.multiauth.model.AuthStore;
import io.appform.dropwizard.multiauth.model.ServiceUser;
import io.appform.dropwizard.multiauth.model.Token;
import io.dropwizard.util.Duration;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GoogleAuthProvider
implements AuthProvider {
    private static final Logger log = LoggerFactory.getLogger(GoogleAuthProvider.class);
    private final HttpTransport transport;
    private final GoogleAuthorizationCodeFlow authorizationCodeFlow;
    private final String redirectionUrl;
    private final AuthConfig authConfig;
    private final ObjectMapper mapper;
    private final AuthStore credentialsStorage;
    private final String callbackPath;

    @Inject
    public GoogleAuthProvider(AuthConfig authConfig, ObjectMapper mapper, AuthStore credentialsStorage, String callbackPath) {
        this.authConfig = authConfig;
        this.callbackPath = callbackPath;
        NetHttpTransport.Builder transportBuilder = new NetHttpTransport.Builder();
        Proxy proxy = Proxy.NO_PROXY;
        MultiAuthConfig googleAuthConfig = authConfig.getProvider();
        if (googleAuthConfig.getProxyType() != null) {
            switch (googleAuthConfig.getProxyType()) {
                case DIRECT: {
                    break;
                }
                case HTTP: {
                    Preconditions.checkArgument((!Strings.isNullOrEmpty((String)googleAuthConfig.getProxyHost()) ? 1 : 0) != 0);
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(googleAuthConfig.getProxyHost(), googleAuthConfig.getProxyPort()));
                    break;
                }
                case SOCKS: {
                    Preconditions.checkArgument((!Strings.isNullOrEmpty((String)googleAuthConfig.getProxyHost()) ? 1 : 0) != 0);
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(googleAuthConfig.getProxyHost(), googleAuthConfig.getProxyPort()));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + (Object)((Object)googleAuthConfig.getProxyType()));
                }
            }
        }
        this.transport = transportBuilder.setProxy(proxy).build();
        this.authorizationCodeFlow = new GoogleAuthorizationCodeFlow.Builder(this.transport, (JsonFactory)new JacksonFactory(), googleAuthConfig.getClientId(), googleAuthConfig.getClientSecret(), (Collection)ImmutableSet.of((Object)"https://www.googleapis.com/auth/userinfo.email")).build();
        this.redirectionUrl = (googleAuthConfig.isSecureEndpoint() ? "https" : "http") + "://" + googleAuthConfig.getServer() + "/auth/google/callback";
        this.mapper = mapper;
        this.credentialsStorage = credentialsStorage;
    }

    @Override
    public String redirectionURL(String sessionId) {
        String url = this.authorizationCodeFlow.newAuthorizationUrl().setState(sessionId).setRedirectUri(this.redirectionUrl).build();
        MultiAuthConfig googleAuthConfig = this.authConfig.getProvider();
        return !Strings.isNullOrEmpty((String)googleAuthConfig.getLoginDomain()) ? url + "&hd=" + googleAuthConfig.getLoginDomain() : url;
    }

    @Override
    public Optional<Token> login(String authToken, String sessionId) {
        String email;
        if (Strings.isNullOrEmpty((String)authToken)) {
            return Optional.empty();
        }
        GoogleAuthorizationCodeTokenRequest googleAuthorizationCodeTokenRequest = this.authorizationCodeFlow.newTokenRequest(authToken);
        try {
            GoogleTokenResponse tokenResponse = googleAuthorizationCodeTokenRequest.setRedirectUri(this.redirectionUrl).execute();
            Credential credential = this.authorizationCodeFlow.createAndStoreCredential((TokenResponse)tokenResponse, null);
            HttpRequestFactory requestFactory = this.transport.createRequestFactory((HttpRequestInitializer)credential);
            GenericUrl url = new GenericUrl("https://www.googleapis.com/oauth2/v1/userinfo");
            HttpRequest request = requestFactory.buildGetRequest(url);
            request.getHeaders().setContentType("application/json");
            String jsonIdentity = request.execute().parseAsString();
            log.debug("Identity: {}", (Object)jsonIdentity);
            email = this.mapper.readTree(jsonIdentity).get("email").asText();
        }
        catch (IOException e) {
            log.error("Error logging in using google:", (Throwable)e);
            return Optional.empty();
        }
        ServiceUser user = this.credentialsStorage.getUser(email).orElse(null);
        if (null == user) {
            log.warn("No authorized user found for email: {}", (Object)email);
            return Optional.empty();
        }
        Duration sessionDuration = Utils.sessionDuration(this.authConfig);
        return this.credentialsStorage.provisionToken(user.getId(), sessionId, new Date(new Date().getTime() + sessionDuration.toMilliseconds()));
    }
}

