/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.multiauth.configs;

import com.google.common.annotations.VisibleForTesting;
import io.dropwizard.util.Duration;
import org.hibernate.validator.constraints.NotEmpty;

public class JwtConfig {
    @NotEmpty
    private String privateKey;
    @NotEmpty
    private String issuerId;
    @NotEmpty
    private String serviceName;
    @NotEmpty
    private String authCachePolicy = "maximumSize=10000, expireAfterAccess=10m";
    private Duration sessionDuration = Duration.days((long)30L);

    @VisibleForTesting
    public JwtConfig(String privateKey, String issuerId) {
        this.privateKey = privateKey;
        this.issuerId = issuerId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getIssuerId() {
        return this.issuerId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getAuthCachePolicy() {
        return this.authCachePolicy;
    }

    public Duration getSessionDuration() {
        return this.sessionDuration;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setIssuerId(String issuerId) {
        this.issuerId = issuerId;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setAuthCachePolicy(String authCachePolicy) {
        this.authCachePolicy = authCachePolicy;
    }

    public void setSessionDuration(Duration sessionDuration) {
        this.sessionDuration = sessionDuration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtConfig)) {
            return false;
        }
        JwtConfig other = (JwtConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$issuerId = this.getIssuerId();
        String other$issuerId = other.getIssuerId();
        if (this$issuerId == null ? other$issuerId != null : !this$issuerId.equals(other$issuerId)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$authCachePolicy = this.getAuthCachePolicy();
        String other$authCachePolicy = other.getAuthCachePolicy();
        if (this$authCachePolicy == null ? other$authCachePolicy != null : !this$authCachePolicy.equals(other$authCachePolicy)) {
            return false;
        }
        Duration this$sessionDuration = this.getSessionDuration();
        Duration other$sessionDuration = other.getSessionDuration();
        return !(this$sessionDuration == null ? other$sessionDuration != null : !this$sessionDuration.equals(other$sessionDuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $issuerId = this.getIssuerId();
        result = result * 59 + ($issuerId == null ? 43 : $issuerId.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $authCachePolicy = this.getAuthCachePolicy();
        result = result * 59 + ($authCachePolicy == null ? 43 : $authCachePolicy.hashCode());
        Duration $sessionDuration = this.getSessionDuration();
        result = result * 59 + ($sessionDuration == null ? 43 : $sessionDuration.hashCode());
        return result;
    }

    public String toString() {
        return "JwtConfig(privateKey=" + this.getPrivateKey() + ", issuerId=" + this.getIssuerId() + ", serviceName=" + this.getServiceName() + ", authCachePolicy=" + this.getAuthCachePolicy() + ", sessionDuration=" + this.getSessionDuration() + ")";
    }

    public JwtConfig() {
    }
}

