/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.multiauth.resources;

import com.google.common.base.Strings;
import io.appform.dropwizard.multiauth.configs.AuthConfig;
import io.appform.dropwizard.multiauth.core.AuthProvider;
import io.appform.dropwizard.multiauth.core.GoogleAuthProvider;
import io.appform.dropwizard.multiauth.core.Utils;
import io.appform.dropwizard.multiauth.model.AuthStore;
import io.appform.dropwizard.multiauth.model.CreateUserRequest;
import io.appform.dropwizard.multiauth.model.ServiceUser;
import io.appform.dropwizard.multiauth.model.Token;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/auth")
public class Auth {
    private static final Logger log = LoggerFactory.getLogger(Auth.class);
    private final AuthConfig authConfig;
    private final AuthProvider authProvider;
    private final AuthStore authStore;

    @Inject
    public Auth(AuthConfig authConfig, GoogleAuthProvider authProvider, AuthStore authStore) {
        this.authConfig = authConfig;
        this.authProvider = authProvider;
        this.authStore = authStore;
    }

    @GET
    @Path(value="/google/login")
    public Response login(@CookieParam(value="redirection") Cookie cookieReferrer, @HeaderParam(value="Referer") String referrer) {
        String sessionId = UUID.randomUUID().toString();
        String redirectionURL = this.authProvider.redirectionURL(sessionId);
        log.debug("Redirection uri: {}", (Object)redirectionURL);
        String cookieReferrerUrl = null == cookieReferrer ? null : cookieReferrer.getValue();
        String source = Strings.isNullOrEmpty((String)cookieReferrerUrl) ? referrer : cookieReferrerUrl;
        log.debug("Call source: {} Referrer: {} Redirection: {}", new Object[]{source, referrer, cookieReferrerUrl});
        if (!Strings.isNullOrEmpty((String)source)) {
            log.debug("Saved: {} against session: {}", (Object)source, (Object)sessionId);
        }
        return Response.seeOther((URI)URI.create(redirectionURL)).cookie(new NewCookie[]{new NewCookie("gauth-state", sessionId, "/auth/google/callback", null, 1, null, -1, null, false, false)}).build();
    }

    @GET
    @Path(value="/google/callback")
    public Response handleGoogleCallback(@CookieParam(value="gauth-state") Cookie cookieState, @Context HttpServletRequest requestContext, @QueryParam(value="state") String sessionId, @QueryParam(value="code") String authCode) {
        log.info("Request Ctx: {}", (Object)requestContext);
        if (null == cookieState || !cookieState.getValue().equals(sessionId)) {
            return Response.seeOther((URI)URI.create("/")).cookie(new NewCookie[]{new NewCookie(cookieState, null, 0, false)}).build();
        }
        Token token = this.authProvider.login(authCode, sessionId).orElse(null);
        if (null == token) {
            return Response.seeOther((URI)URI.create("/auth/google/login")).build();
        }
        return Response.seeOther((URI)URI.create("/")).cookie(new NewCookie[]{new NewCookie("token", Utils.createJWT(token, this.authConfig.getJwt()), "/", null, 1, null, -1, null, false, true), new NewCookie(cookieState, null, 0, false)}).build();
    }

    @POST
    @Path(value="logout")
    public Response logout(@CookieParam(value="token") Cookie token) {
        if (null == token) {
            log.warn("No cookie found");
            return Response.seeOther((URI)URI.create("/")).build();
        }
        log.info("Deleting cookie for user...");
        return Response.seeOther((URI)URI.create("/")).cookie(new NewCookie[]{new NewCookie("token", "", "/", null, 1, null, -1, null, false, true)}).build();
    }

    @POST
    @Path(value="/users")
    @RolesAllowed(value={"AUTH_MANAGEMENT"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response provisionUser(@NotNull @Valid CreateUserRequest createUserRequest) {
        ServiceUser user = new ServiceUser(createUserRequest.getId(), createUserRequest.getRoles(), new Date(), new Date());
        return Response.ok(this.authStore.provisionUser(user)).build();
    }

    @GET
    @Path(value="/users/{userId}")
    @PermitAll
    @Produces(value={"application/json"})
    public Response getUser(@NotNull @NotEmpty @PathParam(value="userId") String userId) {
        return Response.ok(this.authStore.getUser(userId)).build();
    }

    @PUT
    @Path(value="/users/{userId}/roles/grant/{role}")
    @RolesAllowed(value={"AUTH_MANAGEMENT"})
    @Produces(value={"application/json"})
    public Response grantRole(@NotNull @NotEmpty @PathParam(value="userId") String userId, @NotNull @PathParam(value="role") String role) {
        boolean status = this.authStore.grantRole(userId, role);
        return this.updateUserResponse(userId, status);
    }

    @PUT
    @Path(value="/users/{userId}/roles/revoke/{role}")
    @RolesAllowed(value={"AUTH_MANAGEMENT"})
    @Produces(value={"application/json"})
    public Response revokeRole(@NotNull @NotEmpty @PathParam(value="userId") String userId, @NotNull @PathParam(value="role") String role) {
        boolean status = this.authStore.revokeRole(userId, role);
        return this.updateUserResponse(userId, status);
    }

    @POST
    @Path(value="/tokens/{userId}")
    @RolesAllowed(value={"AUTH_MANAGEMENT"})
    @Produces(value={"application/json"})
    public Response provisionToken(@NotNull @NotEmpty @PathParam(value="userId") String userId) {
        Token token = this.authStore.provisionToken(userId, null).orElse(null);
        if (null == token) {
            return Response.notModified().build();
        }
        return Response.ok(Collections.singletonMap("jwt", Utils.createJWT(token, this.authConfig.getJwt()))).build();
    }

    @GET
    @Path(value="/tokens/{tokenId}")
    @PermitAll
    @Produces(value={"application/json"})
    public Response getToken(@NotNull @NotEmpty @PathParam(value="tokenId") String tokenId) {
        return Response.ok(this.authStore.getToken(tokenId)).build();
    }

    @DELETE
    @Path(value="/tokens/{userId}")
    @Produces(value={"application/json"})
    public Response deleteToken(@NotNull @NotEmpty @PathParam(value="userId") String userId, @NotNull @NotEmpty @PathParam(value="tokenId") String tokenId) {
        boolean status = this.authStore.deleteToken(tokenId);
        if (!status) {
            return Response.notModified().build();
        }
        return Response.ok().build();
    }

    private Response updateUserResponse(String userId, boolean status) {
        if (!status) {
            return Response.notModified().build();
        }
        return Response.ok().entity(this.authStore.getUser(userId)).build();
    }
}

