/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.multiauth.model;

import io.appform.dropwizard.multiauth.model.ServiceUser;
import io.appform.dropwizard.multiauth.model.Token;
import io.dropwizard.util.Duration;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;

public interface AuthStore {
    public Optional<ServiceUser> provisionUser(ServiceUser var1);

    public Optional<ServiceUser> getUser(String var1);

    public boolean deleteUser(String var1);

    public boolean updateUser(String var1, UnaryOperator<ServiceUser> var2);

    default public boolean grantRole(String userId, String role) {
        return this.updateUser(userId, user -> {
            Set<Object> roles = user.getRoles() == null ? new HashSet() : user.getRoles();
            roles.add(role);
            return new ServiceUser(userId, roles, user.getCreated(), new Date());
        });
    }

    default public boolean revokeRole(String userId, String role) {
        return this.updateUser(userId, user -> {
            Set<Object> roles = user.getRoles() == null ? new HashSet() : user.getRoles();
            roles.remove(role);
            return new ServiceUser(userId, roles, user.getCreated(), new Date());
        });
    }

    default public Optional<Token> provisionToken(String userId, Date expiry) {
        return this.provisionToken(userId, UUID.randomUUID().toString(), expiry);
    }

    public Optional<Token> provisionToken(String var1, String var2, Date var3);

    public Optional<Token> getToken(String var1);

    public boolean deleteToken(String var1);

    public boolean deleteExpiredTokens(Date var1, Duration var2);
}

