/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.multiauth.core;

import io.appform.dropwizard.multiauth.configs.AuthConfig;
import io.appform.dropwizard.multiauth.model.AuthStore;
import io.appform.dropwizard.multiauth.model.DefaultHandler;
import io.appform.dropwizard.multiauth.model.ServiceUser;
import io.appform.dropwizard.multiauth.model.ServiceUserPrincipal;
import io.appform.dropwizard.multiauth.model.Token;
import io.dropwizard.auth.Authenticator;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.JwtContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TokenAuthenticator
implements Authenticator<JwtContext, ServiceUserPrincipal> {
    private static final Logger log = LoggerFactory.getLogger(TokenAuthenticator.class);
    private final AuthConfig config;
    private final AuthStore authStore;
    private final DefaultHandler defaultHandler;

    @Inject
    public TokenAuthenticator(AuthConfig config, AuthStore authStore, DefaultHandler defaultHandler) {
        this.config = config;
        this.authStore = authStore;
        this.defaultHandler = defaultHandler;
    }

    public Optional<ServiceUserPrincipal> authenticate(JwtContext jwtContext) {
        String serviceName;
        String tokenId;
        String userId;
        if (!this.config.isEnabled()) {
            log.debug("Authentication is disabled");
            return this.defaultHandler.defaultUser();
        }
        log.debug("Auth called");
        try {
            JwtClaims claims = jwtContext.getJwtClaims();
            userId = claims.getSubject();
            tokenId = claims.getJwtId();
            serviceName = (String)claims.getAudience().get(0);
        }
        catch (MalformedClaimException e) {
            log.error(String.format("exception in claim extraction %s", e.getMessage()), (Throwable)e);
            return Optional.empty();
        }
        log.debug("authentication_requested userId:{} tokenId:{}", (Object)userId, (Object)tokenId);
        Token token = this.authStore.getToken(tokenId).orElse(null);
        if (token == null) {
            log.warn("authentication_failed::invalid_session userId:{} tokenId:{}", (Object)userId, (Object)tokenId);
            return Optional.empty();
        }
        if (!token.getUserId().equals(userId)) {
            log.warn("authentication_failed::user_mismatch userId:{} tokenId:{}", (Object)userId, (Object)tokenId);
            return Optional.empty();
        }
        ServiceUser user = this.authStore.getUser(token.getUserId()).orElse(null);
        if (null == user) {
            log.warn("authentication_failed::invalid_user userId:{} tokenId:{}", (Object)userId, (Object)tokenId);
            return Optional.empty();
        }
        String expectedServiceName = this.config.getJwt().getServiceName();
        if (!serviceName.equals(expectedServiceName)) {
            log.warn("authentication_failed::invalid_audience audience provided: {} userid: {} expected: {}", new Object[]{serviceName, userId, expectedServiceName});
            return Optional.empty();
        }
        log.debug("authentication_success userId:{} tokenId:{}", (Object)userId, (Object)tokenId);
        return Optional.of(new ServiceUserPrincipal(user, token));
    }
}

