/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.multiauth.core;

import io.appform.dropwizard.multiauth.model.ServiceUser;
import io.appform.dropwizard.multiauth.model.ServiceUserPrincipal;
import io.dropwizard.auth.Authorizer;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RoleAuthorizer
implements Authorizer<ServiceUserPrincipal> {
    private static final Logger log = LoggerFactory.getLogger(RoleAuthorizer.class);

    public boolean authorize(ServiceUserPrincipal userPrincipal, String role) {
        ServiceUser user = userPrincipal.getUser();
        if (!user.getRoles().contains(role)) {
            log.warn("User {} is trying to access unauthorized role: {}", (Object)user.getId(), (Object)role);
            return false;
        }
        return true;
    }
}

