/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.multiauth;

import com.google.common.cache.CacheBuilderSpec;
import io.appform.dropwizard.multiauth.configs.AuthConfig;
import io.appform.dropwizard.multiauth.core.RoleAuthorizer;
import io.appform.dropwizard.multiauth.integration.UserAuthorizationFilter;
import io.appform.dropwizard.multiauth.model.DefaultHandler;
import io.appform.dropwizard.multiauth.model.ServiceUserPrincipal;
import io.dropwizard.auth.AuthDynamicFeature;
import io.dropwizard.auth.AuthValueFactoryProvider;
import io.dropwizard.auth.Authorizer;
import io.dropwizard.auth.CachingAuthorizer;
import io.dropwizard.setup.Environment;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;

@Provider
public class MultiAuthDynamicFeature
extends AuthDynamicFeature {
    @Inject
    public MultiAuthDynamicFeature(Environment environment, AuthConfig authConfig, DefaultHandler defaultHandler) {
        super((ContainerRequestFilter)new UserAuthorizationFilter(authConfig, (Authorizer<ServiceUserPrincipal>)new CachingAuthorizer(environment.metrics(), (Authorizer)new RoleAuthorizer(), CacheBuilderSpec.parse((String)authConfig.getJwt().getAuthCachePolicy())), defaultHandler));
        environment.jersey().register((Object)new AuthValueFactoryProvider.Binder(ServiceUserPrincipal.class));
        environment.jersey().register(RolesAllowedDynamicFeature.class);
    }
}

