/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.discovery.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.ranger.ServiceFinderBuilders;
import com.flipkart.ranger.finder.sharded.SimpleShardedServiceFinder;
import com.flipkart.ranger.model.ServiceNode;
import com.flipkart.ranger.model.ShardSelector;
import io.appform.dropwizard.discovery.client.selector.HierarchicalEnvironmentAwareShardSelector;
import io.appform.dropwizard.discovery.common.ShardInfo;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryForever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscoveryClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscoveryClient.class);
    private final ShardInfo criteria;
    private SimpleShardedServiceFinder<ShardInfo> serviceFinder;

    private ServiceDiscoveryClient(String namespace, String serviceName, String environment, ObjectMapper objectMapper, String connectionString, int refreshTimeMs, boolean disableWatchers) {
        this(namespace, serviceName, environment, objectMapper, CuratorFrameworkFactory.newClient((String)connectionString, (RetryPolicy)new RetryForever(5000)), refreshTimeMs, disableWatchers);
    }

    ServiceDiscoveryClient(String namespace, String serviceName, String environment, ObjectMapper objectMapper, CuratorFramework curator, int refreshTimeMs, boolean disableWatchers) {
        int effectiveRefreshTimeMs = refreshTimeMs;
        if (effectiveRefreshTimeMs < 5000) {
            effectiveRefreshTimeMs = 5000;
            log.warn("Node info update interval too low: {} ms. Has been upgraded to {} ms ", (Object)refreshTimeMs, (Object)5000);
        }
        this.criteria = ShardInfo.builder().environment(environment).build();
        this.serviceFinder = (SimpleShardedServiceFinder)ServiceFinderBuilders.shardedFinderBuilder().withCuratorFramework(curator).withNamespace(namespace).withServiceName(serviceName).withDeserializer(data -> {
            try {
                return (ServiceNode)objectMapper.readValue(data, (TypeReference)new TypeReference<ServiceNode<ShardInfo>>(){});
            }
            catch (Exception e) {
                log.warn("Could not parse node data", (Throwable)e);
                return null;
            }
        }).withNodeRefreshIntervalMs(effectiveRefreshTimeMs).withDisableWatchers(disableWatchers).withShardSelector((ShardSelector)new HierarchicalEnvironmentAwareShardSelector()).build();
    }

    public void start() throws Exception {
        this.serviceFinder.start();
    }

    public void stop() throws Exception {
        this.serviceFinder.stop();
    }

    public Optional<ServiceNode<ShardInfo>> getNode() {
        return this.getNode(this.criteria);
    }

    public List<ServiceNode<ShardInfo>> getAllNodes() {
        return this.getAllNodes(this.criteria);
    }

    public Optional<ServiceNode<ShardInfo>> getNode(ShardInfo shardInfo) {
        return Optional.ofNullable(this.serviceFinder.get((Object)shardInfo));
    }

    public List<ServiceNode<ShardInfo>> getAllNodes(ShardInfo shardInfo) {
        return this.serviceFinder.getAll((Object)shardInfo);
    }

    @Generated
    public static FromConnectionStringBuilder fromConnectionString() {
        return new FromConnectionStringBuilder();
    }

    @Generated
    public static FromCuratorBuilder fromCurator() {
        return new FromCuratorBuilder();
    }

    @Generated
    public static class FromCuratorBuilder {
        @Generated
        private String namespace;
        @Generated
        private String serviceName;
        @Generated
        private String environment;
        @Generated
        private ObjectMapper objectMapper;
        @Generated
        private CuratorFramework curator;
        @Generated
        private int refreshTimeMs;
        @Generated
        private boolean disableWatchers;

        @Generated
        FromCuratorBuilder() {
        }

        @Generated
        public FromCuratorBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public FromCuratorBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Generated
        public FromCuratorBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        @Generated
        public FromCuratorBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public FromCuratorBuilder curator(CuratorFramework curator) {
            this.curator = curator;
            return this;
        }

        @Generated
        public FromCuratorBuilder refreshTimeMs(int refreshTimeMs) {
            this.refreshTimeMs = refreshTimeMs;
            return this;
        }

        @Generated
        public FromCuratorBuilder disableWatchers(boolean disableWatchers) {
            this.disableWatchers = disableWatchers;
            return this;
        }

        @Generated
        public ServiceDiscoveryClient build() {
            return new ServiceDiscoveryClient(this.namespace, this.serviceName, this.environment, this.objectMapper, this.curator, this.refreshTimeMs, this.disableWatchers);
        }

        @Generated
        public String toString() {
            return "ServiceDiscoveryClient.FromCuratorBuilder(namespace=" + this.namespace + ", serviceName=" + this.serviceName + ", environment=" + this.environment + ", objectMapper=" + this.objectMapper + ", curator=" + this.curator + ", refreshTimeMs=" + this.refreshTimeMs + ", disableWatchers=" + this.disableWatchers + ")";
        }
    }

    @Generated
    public static class FromConnectionStringBuilder {
        @Generated
        private String namespace;
        @Generated
        private String serviceName;
        @Generated
        private String environment;
        @Generated
        private ObjectMapper objectMapper;
        @Generated
        private String connectionString;
        @Generated
        private int refreshTimeMs;
        @Generated
        private boolean disableWatchers;

        @Generated
        FromConnectionStringBuilder() {
        }

        @Generated
        public FromConnectionStringBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Generated
        public FromConnectionStringBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Generated
        public FromConnectionStringBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        @Generated
        public FromConnectionStringBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public FromConnectionStringBuilder connectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        @Generated
        public FromConnectionStringBuilder refreshTimeMs(int refreshTimeMs) {
            this.refreshTimeMs = refreshTimeMs;
            return this;
        }

        @Generated
        public FromConnectionStringBuilder disableWatchers(boolean disableWatchers) {
            this.disableWatchers = disableWatchers;
            return this;
        }

        @Generated
        public ServiceDiscoveryClient build() {
            return new ServiceDiscoveryClient(this.namespace, this.serviceName, this.environment, this.objectMapper, this.connectionString, this.refreshTimeMs, this.disableWatchers);
        }

        @Generated
        public String toString() {
            return "ServiceDiscoveryClient.FromConnectionStringBuilder(namespace=" + this.namespace + ", serviceName=" + this.serviceName + ", environment=" + this.environment + ", objectMapper=" + this.objectMapper + ", connectionString=" + this.connectionString + ", refreshTimeMs=" + this.refreshTimeMs + ", disableWatchers=" + this.disableWatchers + ")";
        }
    }
}

