/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.actors.retry.config;

import io.appform.dropwizard.actors.retry.RetryType;
import io.appform.dropwizard.actors.retry.config.RetryConfig;
import io.dropwizard.util.Duration;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class CountLimitedFixedWaitRetryConfig
extends RetryConfig {
    @Min(value=1L)
    private @Min(value=1L) int maxAttempts = 1;
    @NotNull
    @Valid
    private Duration waitTime = Duration.milliseconds((long)500L);

    public CountLimitedFixedWaitRetryConfig() {
        super(RetryType.COUNT_LIMITED_FIXED_WAIT);
    }

    public CountLimitedFixedWaitRetryConfig(int maxAttempts, Duration waitTime, Set<String> retriableExceptions) {
        super(RetryType.COUNT_LIMITED_FIXED_WAIT, retriableExceptions);
        this.maxAttempts = maxAttempts;
        this.waitTime = waitTime;
    }

    public static CountLimitedFixedWaitRetryConfigBuilder builder() {
        return new CountLimitedFixedWaitRetryConfigBuilder();
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public Duration getWaitTime() {
        return this.waitTime;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setWaitTime(Duration waitTime) {
        this.waitTime = waitTime;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountLimitedFixedWaitRetryConfig)) {
            return false;
        }
        CountLimitedFixedWaitRetryConfig other = (CountLimitedFixedWaitRetryConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getMaxAttempts() != other.getMaxAttempts()) {
            return false;
        }
        Duration this$waitTime = this.getWaitTime();
        Duration other$waitTime = other.getWaitTime();
        return !(this$waitTime == null ? other$waitTime != null : !this$waitTime.equals(other$waitTime));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CountLimitedFixedWaitRetryConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getMaxAttempts();
        Duration $waitTime = this.getWaitTime();
        result = result * 59 + ($waitTime == null ? 43 : $waitTime.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CountLimitedFixedWaitRetryConfig(super=" + super.toString() + ", maxAttempts=" + this.getMaxAttempts() + ", waitTime=" + this.getWaitTime() + ")";
    }

    public static class CountLimitedFixedWaitRetryConfigBuilder {
        private int maxAttempts;
        private Duration waitTime;
        private Set<String> retriableExceptions;

        CountLimitedFixedWaitRetryConfigBuilder() {
        }

        public CountLimitedFixedWaitRetryConfigBuilder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public CountLimitedFixedWaitRetryConfigBuilder waitTime(Duration waitTime) {
            this.waitTime = waitTime;
            return this;
        }

        public CountLimitedFixedWaitRetryConfigBuilder retriableExceptions(Set<String> retriableExceptions) {
            this.retriableExceptions = retriableExceptions;
            return this;
        }

        public CountLimitedFixedWaitRetryConfig build() {
            return new CountLimitedFixedWaitRetryConfig(this.maxAttempts, this.waitTime, this.retriableExceptions);
        }

        public String toString() {
            return "CountLimitedFixedWaitRetryConfig.CountLimitedFixedWaitRetryConfigBuilder(maxAttempts=" + this.maxAttempts + ", waitTime=" + this.waitTime + ", retriableExceptions=" + this.retriableExceptions + ")";
        }
    }
}

