/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.actors.config;

import io.appform.dropwizard.actors.config.Broker;
import io.appform.dropwizard.actors.connectivity.ConnectionConfig;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class RMQConfig {
    @NotNull
    @NotEmpty
    private List<Broker> brokers;
    @NotEmpty
    @NotNull
    private String userName;
    @NotNull
    private int threadPoolSize;
    @NotEmpty
    @NotNull
    private String password;
    private String virtualHost;
    private boolean secure;
    @Min(value=0L)
    @Max(value=1024L)
    private @Min(value=0L) @Max(value=1024L) int startupGracePeriodSeconds = 0;
    private String certStorePath;
    private String certPassword;
    private String serverCertStorePath;
    private String serverCertPassword;
    @Valid
    private List<ConnectionConfig> connections;

    private static String $default$virtualHost() {
        return "/";
    }

    public static RMQConfigBuilder builder() {
        return new RMQConfigBuilder();
    }

    public List<Broker> getBrokers() {
        return this.brokers;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public String getPassword() {
        return this.password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public int getStartupGracePeriodSeconds() {
        return this.startupGracePeriodSeconds;
    }

    public String getCertStorePath() {
        return this.certStorePath;
    }

    public String getCertPassword() {
        return this.certPassword;
    }

    public String getServerCertStorePath() {
        return this.serverCertStorePath;
    }

    public String getServerCertPassword() {
        return this.serverCertPassword;
    }

    public List<ConnectionConfig> getConnections() {
        return this.connections;
    }

    public void setBrokers(List<Broker> brokers) {
        this.brokers = brokers;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setStartupGracePeriodSeconds(int startupGracePeriodSeconds) {
        this.startupGracePeriodSeconds = startupGracePeriodSeconds;
    }

    public void setCertStorePath(String certStorePath) {
        this.certStorePath = certStorePath;
    }

    public void setCertPassword(String certPassword) {
        this.certPassword = certPassword;
    }

    public void setServerCertStorePath(String serverCertStorePath) {
        this.serverCertStorePath = serverCertStorePath;
    }

    public void setServerCertPassword(String serverCertPassword) {
        this.serverCertPassword = serverCertPassword;
    }

    public void setConnections(List<ConnectionConfig> connections) {
        this.connections = connections;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RMQConfig)) {
            return false;
        }
        RMQConfig other = (RMQConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getThreadPoolSize() != other.getThreadPoolSize()) {
            return false;
        }
        if (this.isSecure() != other.isSecure()) {
            return false;
        }
        if (this.getStartupGracePeriodSeconds() != other.getStartupGracePeriodSeconds()) {
            return false;
        }
        List<Broker> this$brokers = this.getBrokers();
        List<Broker> other$brokers = other.getBrokers();
        if (this$brokers == null ? other$brokers != null : !((Object)this$brokers).equals(other$brokers)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$virtualHost = this.getVirtualHost();
        String other$virtualHost = other.getVirtualHost();
        if (this$virtualHost == null ? other$virtualHost != null : !this$virtualHost.equals(other$virtualHost)) {
            return false;
        }
        String this$certStorePath = this.getCertStorePath();
        String other$certStorePath = other.getCertStorePath();
        if (this$certStorePath == null ? other$certStorePath != null : !this$certStorePath.equals(other$certStorePath)) {
            return false;
        }
        String this$certPassword = this.getCertPassword();
        String other$certPassword = other.getCertPassword();
        if (this$certPassword == null ? other$certPassword != null : !this$certPassword.equals(other$certPassword)) {
            return false;
        }
        String this$serverCertStorePath = this.getServerCertStorePath();
        String other$serverCertStorePath = other.getServerCertStorePath();
        if (this$serverCertStorePath == null ? other$serverCertStorePath != null : !this$serverCertStorePath.equals(other$serverCertStorePath)) {
            return false;
        }
        String this$serverCertPassword = this.getServerCertPassword();
        String other$serverCertPassword = other.getServerCertPassword();
        if (this$serverCertPassword == null ? other$serverCertPassword != null : !this$serverCertPassword.equals(other$serverCertPassword)) {
            return false;
        }
        List<ConnectionConfig> this$connections = this.getConnections();
        List<ConnectionConfig> other$connections = other.getConnections();
        return !(this$connections == null ? other$connections != null : !((Object)this$connections).equals(other$connections));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RMQConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getThreadPoolSize();
        result = result * 59 + (this.isSecure() ? 79 : 97);
        result = result * 59 + this.getStartupGracePeriodSeconds();
        List<Broker> $brokers = this.getBrokers();
        result = result * 59 + ($brokers == null ? 43 : ((Object)$brokers).hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $virtualHost = this.getVirtualHost();
        result = result * 59 + ($virtualHost == null ? 43 : $virtualHost.hashCode());
        String $certStorePath = this.getCertStorePath();
        result = result * 59 + ($certStorePath == null ? 43 : $certStorePath.hashCode());
        String $certPassword = this.getCertPassword();
        result = result * 59 + ($certPassword == null ? 43 : $certPassword.hashCode());
        String $serverCertStorePath = this.getServerCertStorePath();
        result = result * 59 + ($serverCertStorePath == null ? 43 : $serverCertStorePath.hashCode());
        String $serverCertPassword = this.getServerCertPassword();
        result = result * 59 + ($serverCertPassword == null ? 43 : $serverCertPassword.hashCode());
        List<ConnectionConfig> $connections = this.getConnections();
        result = result * 59 + ($connections == null ? 43 : ((Object)$connections).hashCode());
        return result;
    }

    public String toString() {
        return "RMQConfig(brokers=" + this.getBrokers() + ", userName=" + this.getUserName() + ", threadPoolSize=" + this.getThreadPoolSize() + ", password=" + this.getPassword() + ", virtualHost=" + this.getVirtualHost() + ", secure=" + this.isSecure() + ", startupGracePeriodSeconds=" + this.getStartupGracePeriodSeconds() + ", certStorePath=" + this.getCertStorePath() + ", certPassword=" + this.getCertPassword() + ", serverCertStorePath=" + this.getServerCertStorePath() + ", serverCertPassword=" + this.getServerCertPassword() + ", connections=" + this.getConnections() + ")";
    }

    public RMQConfig(List<Broker> brokers, String userName, int threadPoolSize, String password, String virtualHost, boolean secure, int startupGracePeriodSeconds, String certStorePath, String certPassword, String serverCertStorePath, String serverCertPassword, List<ConnectionConfig> connections) {
        this.brokers = brokers;
        this.userName = userName;
        this.threadPoolSize = threadPoolSize;
        this.password = password;
        this.virtualHost = virtualHost;
        this.secure = secure;
        this.startupGracePeriodSeconds = startupGracePeriodSeconds;
        this.certStorePath = certStorePath;
        this.certPassword = certPassword;
        this.serverCertStorePath = serverCertStorePath;
        this.serverCertPassword = serverCertPassword;
        this.connections = connections;
    }

    public RMQConfig() {
        this.virtualHost = RMQConfig.$default$virtualHost();
    }

    public static class RMQConfigBuilder {
        private List<Broker> brokers;
        private String userName;
        private int threadPoolSize;
        private String password;
        private boolean virtualHost$set;
        private String virtualHost$value;
        private boolean secure;
        private int startupGracePeriodSeconds;
        private String certStorePath;
        private String certPassword;
        private String serverCertStorePath;
        private String serverCertPassword;
        private List<ConnectionConfig> connections;

        RMQConfigBuilder() {
        }

        public RMQConfigBuilder brokers(List<Broker> brokers) {
            this.brokers = brokers;
            return this;
        }

        public RMQConfigBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public RMQConfigBuilder threadPoolSize(int threadPoolSize) {
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        public RMQConfigBuilder password(String password) {
            this.password = password;
            return this;
        }

        public RMQConfigBuilder virtualHost(String virtualHost) {
            this.virtualHost$value = virtualHost;
            this.virtualHost$set = true;
            return this;
        }

        public RMQConfigBuilder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public RMQConfigBuilder startupGracePeriodSeconds(int startupGracePeriodSeconds) {
            this.startupGracePeriodSeconds = startupGracePeriodSeconds;
            return this;
        }

        public RMQConfigBuilder certStorePath(String certStorePath) {
            this.certStorePath = certStorePath;
            return this;
        }

        public RMQConfigBuilder certPassword(String certPassword) {
            this.certPassword = certPassword;
            return this;
        }

        public RMQConfigBuilder serverCertStorePath(String serverCertStorePath) {
            this.serverCertStorePath = serverCertStorePath;
            return this;
        }

        public RMQConfigBuilder serverCertPassword(String serverCertPassword) {
            this.serverCertPassword = serverCertPassword;
            return this;
        }

        public RMQConfigBuilder connections(List<ConnectionConfig> connections) {
            this.connections = connections;
            return this;
        }

        public RMQConfig build() {
            String virtualHost$value = this.virtualHost$value;
            if (!this.virtualHost$set) {
                virtualHost$value = RMQConfig.$default$virtualHost();
            }
            return new RMQConfig(this.brokers, this.userName, this.threadPoolSize, this.password, virtualHost$value, this.secure, this.startupGracePeriodSeconds, this.certStorePath, this.certPassword, this.serverCertStorePath, this.serverCertPassword, this.connections);
        }

        public String toString() {
            return "RMQConfig.RMQConfigBuilder(brokers=" + this.brokers + ", userName=" + this.userName + ", threadPoolSize=" + this.threadPoolSize + ", password=" + this.password + ", virtualHost$value=" + this.virtualHost$value + ", secure=" + this.secure + ", startupGracePeriodSeconds=" + this.startupGracePeriodSeconds + ", certStorePath=" + this.certStorePath + ", certPassword=" + this.certPassword + ", serverCertStorePath=" + this.serverCertStorePath + ", serverCertPassword=" + this.serverCertPassword + ", connections=" + this.connections + ")";
        }
    }
}

