/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.actors.config;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class Broker {
    @NotEmpty
    @NotNull
    private String host;
    @Min(value=0L)
    @Max(value=65535L)
    private @Min(value=0L) @Max(value=65535L) int port;

    public static BrokerBuilder builder() {
        return new BrokerBuilder();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Broker)) {
            return false;
        }
        Broker other = (Broker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Broker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    public String toString() {
        return "Broker(host=" + this.getHost() + ", port=" + this.getPort() + ")";
    }

    public Broker(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public Broker() {
    }

    public static class BrokerBuilder {
        private String host;
        private int port;

        BrokerBuilder() {
        }

        public BrokerBuilder host(String host) {
            this.host = host;
            return this;
        }

        public BrokerBuilder port(int port) {
            this.port = port;
            return this;
        }

        public Broker build() {
            return new Broker(this.host, this.port);
        }

        public String toString() {
            return "Broker.BrokerBuilder(host=" + this.host + ", port=" + this.port + ")";
        }
    }
}

