/*
 * Decompiled with CFR 0.152.
 */
package io.appform.dropwizard.actors.base.utils;

import io.appform.dropwizard.actors.utils.CommonUtils;

public class NamingUtils {
    public static final String NAMESPACE_ENV_NAME = "NAMESPACE_ENV_NAME";

    public static String queueName(String prefix, String name) {
        String nameWithPrefix = String.format("%s.%s", prefix, name);
        return NamingUtils.prefixWithNamespace(nameWithPrefix);
    }

    public static String sanitizeMetricName(String metric) {
        return metric == null ? null : metric.replaceAll("[^A-Za-z\\-0-9]", "").toLowerCase();
    }

    public static String prefixWithNamespace(String name) {
        String namespace = System.getenv(NAMESPACE_ENV_NAME);
        if (CommonUtils.isEmpty(namespace)) {
            return name;
        }
        return String.format("%s.%s", namespace, name);
    }

    public static String getShardedQueueName(String queueName, int shardId) {
        return queueName + "_" + shardId;
    }

    private NamingUtils() {
    }
}

